/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.tools;

import java.io.IOException;
import java.net.URL;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.program.Program;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalWebBrowser {
    private static Logger logger = LoggerFactory.getLogger(ExternalWebBrowser.class);

    public static void open(URL url) {
        ExternalWebBrowser.open(url.toString());
    }

    public static void open(String url) {
        if (url.startsWith("file:")) {
            url = url.substring(5);
            while (url.startsWith("/")) {
                url = url.substring(1);
            }
            url = "file:///" + url;
        }
        if (Util.isWindows()) {
            Program.launch((String)url);
        } else if (Util.isMac()) {
            try {
                Runtime.getRuntime().exec("/usr/bin/open '" + url + "'");
            }
            catch (IOException e) {
                logger.error("Exception while starting external browser", (Throwable)e);
            }
        } else {
            try {
                Runtime.getRuntime().exec("xdg-open " + ExternalWebBrowser.urlEncode(url));
            }
            catch (IOException e) {
                logger.error("Exception while starting external browser", (Throwable)e);
            }
        }
    }

    private static String urlEncode(String url) {
        StringBuilder sb = new StringBuilder(url.length());
        char[] cArray = url.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == ' ') {
                sb.append("%20");
            } else {
                sb.append(c);
            }
            ++n2;
        }
        return sb.toString();
    }
}

