/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.tools;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.netxms.ui.eclipse.tools.SelectionTransformation;

public class IntermediateSelectionProvider
implements IPostSelectionProvider {
    private final ListenerList<ISelectionChangedListener> selectionListeners = new ListenerList();
    private final ListenerList<ISelectionChangedListener> postSelectionListeners = new ListenerList();
    private ISelectionProvider delegate = null;
    private SelectionTransformation transformation;
    private ISelectionChangedListener selectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            if (event.getSelectionProvider() == IntermediateSelectionProvider.this.delegate) {
                IntermediateSelectionProvider.this.fireSelectionChanged(IntermediateSelectionProvider.this.transformation.transform(event.getSelection()));
            }
        }
    };
    private ISelectionChangedListener postSelectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            if (event.getSelectionProvider() == IntermediateSelectionProvider.this.delegate) {
                IntermediateSelectionProvider.this.firePostSelectionChanged(IntermediateSelectionProvider.this.transformation.transform(event.getSelection()));
            }
        }
    };

    public IntermediateSelectionProvider() {
        this.transformation = new DummyTransformation();
    }

    public IntermediateSelectionProvider(ISelectionProvider delegate) {
        this.transformation = new DummyTransformation();
        this.setSelectionProviderDelegate(delegate);
    }

    public IntermediateSelectionProvider(SelectionTransformation transformation) {
        this.transformation = transformation;
    }

    public IntermediateSelectionProvider(ISelectionProvider delegate, SelectionTransformation transformation) {
        this.transformation = transformation;
        this.setSelectionProviderDelegate(delegate);
    }

    public void setSelectionProviderDelegate(ISelectionProvider newDelegate) {
        if (this.delegate == newDelegate) {
            return;
        }
        if (this.delegate != null) {
            this.delegate.removeSelectionChangedListener(this.selectionListener);
            if (this.delegate instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)this.delegate).removePostSelectionChangedListener(this.postSelectionListener);
            }
        }
        this.delegate = newDelegate;
        if (newDelegate != null) {
            newDelegate.addSelectionChangedListener(this.selectionListener);
            if (newDelegate instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)newDelegate).addPostSelectionChangedListener(this.postSelectionListener);
            }
            ISelection selection = this.transformation.transform(newDelegate.getSelection());
            this.fireSelectionChanged(selection);
            this.firePostSelectionChanged(selection);
        }
    }

    protected void fireSelectionChanged(ISelection selection) {
        this.fireSelectionChanged(this.selectionListeners, selection);
    }

    protected void firePostSelectionChanged(ISelection selection) {
        this.fireSelectionChanged(this.postSelectionListeners, selection);
    }

    private void fireSelectionChanged(ListenerList<ISelectionChangedListener> list, ISelection selection) {
        SelectionChangedEvent event = new SelectionChangedEvent(this.delegate, selection);
        Object[] listeners = list.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ISelectionChangedListener listener = (ISelectionChangedListener)listeners[i];
            listener.selectionChanged(event);
            ++i;
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove((Object)listener);
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        this.postSelectionListeners.add((Object)listener);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        this.postSelectionListeners.remove((Object)listener);
    }

    public ISelection getSelection() {
        return this.delegate == null ? null : this.transformation.transform(this.delegate.getSelection());
    }

    public void setSelection(ISelection selection) {
        if (this.delegate != null) {
            this.delegate.setSelection(selection);
        }
    }

    private class DummyTransformation
    implements SelectionTransformation {
        private DummyTransformation() {
        }

        @Override
        public ISelection transform(ISelection input) {
            return input;
        }
    }
}

