/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.widgets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.netxms.ui.eclipse.console.Activator;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class PerspectiveSwitcher
extends Composite {
    private Label currentPerspective;
    private ToolBar toolbar;

    private static Composite findParent(IWorkbenchWindow window) {
        Control[] children = window.getShell().getChildren();
        return (Composite)children[children.length - 1];
    }

    public PerspectiveSwitcher(final IWorkbenchWindow window) {
        super(PerspectiveSwitcher.findParent(window), 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 10;
        this.setLayout((Layout)layout);
        this.currentPerspective = new Label((Composite)this, 131072);
        this.currentPerspective.setFont(JFaceResources.getBannerFont());
        IPerspectiveDescriptor p = window.getActivePage().getPerspective();
        if (p != null) {
            this.currentPerspective.setText(p.getLabel());
        }
        Menu menu = new Menu((Control)this.currentPerspective);
        MenuItem mi = new MenuItem(menu, 8);
        mi.setText("&Reset perspective");
        mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                window.getActivePage().resetPerspective();
            }
        });
        this.currentPerspective.setMenu(menu);
        this.toolbar = new ToolBar((Composite)this, 0x800000);
        final ToolItem selectorButton = new ToolItem(this.toolbar, 8);
        selectorButton.setImage(Activator.getImageDescriptor("icons/perspectives-menu.png").createImage());
        selectorButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                selectorButton.getImage().dispose();
            }
        });
        final MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                for (final IPerspectiveDescriptor p : PerspectiveSwitcher.getVisiblePerspectives()) {
                    manager.add((IAction)new Action(p.getLabel(), p.getImageDescriptor()){

                        public void run() {
                            window.getActivePage().setPerspective(p);
                        }
                    });
                }
            }
        });
        manager.createContextMenu((Control)this.toolbar);
        selectorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                manager.getMenu().setVisible(true);
            }
        });
        window.addPerspectiveListener(new IPerspectiveListener(){

            public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
            }

            public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                PerspectiveSwitcher.this.currentPerspective.setText(perspective.getLabel());
                window.getShell().layout(true, true);
            }
        });
    }

    public static List<IPerspectiveDescriptor> getVisiblePerspectives() {
        ArrayList<String> disabledPerspectives;
        int n;
        ArrayList<String> enabledPerspectives;
        ArrayList<IPerspectiveDescriptor> visiblePerspectives = new ArrayList<IPerspectiveDescriptor>();
        String v = ConsoleSharedData.getSession().getClientConfigurationHint("PerspectiveSwitcher.EnabledPerspectives");
        if (v != null && !v.isEmpty()) {
            String[] parts = v.split(",");
            enabledPerspectives = new ArrayList<String>(parts.length);
            String[] stringArray = parts;
            n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (!s.isBlank()) {
                    enabledPerspectives.add(s.trim().toLowerCase());
                }
                ++n2;
            }
        } else {
            enabledPerspectives = null;
        }
        v = ConsoleSharedData.getSession().getClientConfigurationHint("PerspectiveSwitcher.DisabledPerspectives");
        if (v != null && !v.isEmpty()) {
            String[] parts = v.split(",");
            disabledPerspectives = new ArrayList<String>(parts.length);
            String[] stringArray = parts;
            int n3 = parts.length;
            n = 0;
            while (n < n3) {
                String s = stringArray[n];
                if (!s.isBlank()) {
                    disabledPerspectives.add(s.trim().toLowerCase());
                }
                ++n;
            }
        } else {
            disabledPerspectives = null;
        }
        IPerspectiveDescriptor[] perspectives = PlatformUI.getWorkbench().getPerspectiveRegistry().getPerspectives();
        if (enabledPerspectives != null) {
            Arrays.sort(perspectives, new Comparator<IPerspectiveDescriptor>(){

                @Override
                public int compare(IPerspectiveDescriptor p1, IPerspectiveDescriptor p2) {
                    return enabledPerspectives.indexOf(p1.getLabel().toLowerCase()) - enabledPerspectives.indexOf(p2.getLabel().toLowerCase());
                }
            });
        }
        String customizationId = ConsoleSharedData.getSession().getClientConfigurationHint("CustomizationId");
        IPerspectiveDescriptor[] iPerspectiveDescriptorArray = perspectives;
        int n4 = perspectives.length;
        int n5 = 0;
        while (n5 < n4) {
            IPerspectiveDescriptor p = iPerspectiveDescriptorArray[n5];
            if (!(p.getLabel().startsWith("<") || p.getId().equals("org.netxms.ui.eclipse.console.SwitcherPerspective") || enabledPerspectives != null && !enabledPerspectives.contains(p.getLabel().toLowerCase()) || disabledPerspectives != null && disabledPerspectives.contains(p.getLabel().toLowerCase()) || p.getId().startsWith("com.radensolutions.netxms.ui.perspective.custom.") && (customizationId == null || !p.getId().startsWith("com.radensolutions.netxms.ui.perspective.custom." + customizationId + ".")))) {
                visiblePerspectives.add(p);
            }
            ++n5;
        }
        return visiblePerspectives;
    }
}

