/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.widgets;

import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TextEditor
extends Composite
implements IFindReplaceTarget {
    private Text editor;

    public TextEditor(Composite parent, int style, int editorSyle) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.editor = new Text((Composite)this, editorSyle);
    }

    public boolean canPerformFind() {
        return true;
    }

    public int findAndSelect(int widgetOffset, String findString, boolean searchForward, boolean caseSensitive, boolean wholeWord) {
        int index;
        String content = widgetOffset == -1 ? this.editor.getText() : (searchForward ? this.editor.getText().substring(widgetOffset) : this.editor.getText().substring(0, widgetOffset + 1));
        if (caseSensitive) {
            content = content.toUpperCase();
            findString = findString.toUpperCase();
        }
        int n = index = searchForward ? content.indexOf(findString) : content.lastIndexOf(findString);
        if (index != -1) {
            if (widgetOffset >= 0 && searchForward) {
                index += widgetOffset;
            }
            this.editor.setSelection(index, index + findString.length());
        }
        return index;
    }

    public Point getSelection() {
        Point s = this.editor.getSelection();
        s.y -= s.x;
        return s;
    }

    public String getSelectionText() {
        return this.editor.getSelectionText();
    }

    public boolean isEditable() {
        return true;
    }

    public void replaceSelection(String text) {
        String content = this.editor.getText();
        Point s = this.editor.getSelection();
        String start = content.substring(0, s.x);
        String tail = content.substring(s.y);
        this.editor.setText(String.valueOf(start) + text + tail);
    }

    public Text getTextControl() {
        return this.editor;
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.editor.addModifyListener(modifyListener);
    }

    public String getText() {
        return this.editor.getText();
    }

    public void setText(String text) {
        this.editor.setText(text);
    }
}

