/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.widgets;

import java.util.Date;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.netxms.client.TimePeriod;
import org.netxms.client.constants.TimeFrameType;
import org.netxms.client.constants.TimeUnit;
import org.netxms.ui.eclipse.console.Messages;
import org.netxms.ui.eclipse.tools.WidgetFactory;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.DateTimeSelector;

public class TimePeriodSelector
extends Composite {
    private Button radioBackFromNow;
    private Button radioFixedInterval;
    private Spinner timeRange;
    private Combo timeUnits;
    private DateTimeSelector timeFrom;
    private DateTimeSelector timeTo;

    public TimePeriodSelector(Composite parent, int style, TimePeriod period) {
        super(parent, style & 0xFFFFFCFF);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 4;
        layout.marginHeight = 4;
        layout.horizontalSpacing = 16;
        layout.makeColumnsEqualWidth = true;
        layout.numColumns = (style & 0x200) != 0 ? 1 : 2;
        this.setLayout((Layout)layout);
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TimePeriodSelector.this.timeRange.setEnabled(TimePeriodSelector.this.radioBackFromNow.getSelection());
                TimePeriodSelector.this.timeUnits.setEnabled(TimePeriodSelector.this.radioBackFromNow.getSelection());
                TimePeriodSelector.this.timeFrom.setEnabled(TimePeriodSelector.this.radioFixedInterval.getSelection());
                TimePeriodSelector.this.timeTo.setEnabled(TimePeriodSelector.this.radioFixedInterval.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this.radioBackFromNow = new Button((Composite)this, 16);
        Messages.get();
        this.radioBackFromNow.setText(Messages.TimePeriodSelector_BackFromNow);
        this.radioBackFromNow.addSelectionListener(listener);
        if ((style & 0x200) == 0) {
            this.radioFixedInterval = new Button((Composite)this, 16);
            Messages.get();
            this.radioFixedInterval.setText(Messages.TimePeriodSelector_FixedTimeFrame);
            this.radioFixedInterval.addSelectionListener(listener);
        }
        Composite timeBackGroup = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 4;
        layout.numColumns = 2;
        timeBackGroup.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 128;
        timeBackGroup.setLayoutData((Object)gd);
        Messages.get();
        this.timeRange = WidgetHelper.createLabeledSpinner(timeBackGroup, 2048, Messages.TimePeriodSelector_TimeInterval, 1, 10000, "WidgetHelper::default_layout_data");
        this.timeRange.setEnabled(this.radioBackFromNow.getSelection());
        Messages.get();
        this.timeUnits = WidgetHelper.createLabeledCombo(timeBackGroup, 8, Messages.TimePeriodSelector_TimeUnits, "WidgetHelper::default_layout_data");
        Messages.get();
        this.timeUnits.add(Messages.TimePeriodSelector_Minutes);
        Messages.get();
        this.timeUnits.add(Messages.TimePeriodSelector_Hours);
        Messages.get();
        this.timeUnits.add(Messages.TimePeriodSelector_Days);
        this.timeUnits.setEnabled(this.radioBackFromNow.getSelection());
        if ((style & 0x200) != 0) {
            Composite filler = new Composite((Composite)this, 0);
            gd = new GridData();
            gd.heightHint = 11;
            filler.setLayoutData((Object)gd);
            this.radioFixedInterval = new Button((Composite)this, 16);
            Messages.get();
            this.radioFixedInterval.setText(Messages.TimePeriodSelector_FixedTimeFrame);
            this.radioFixedInterval.setSelection(period.getTimeFrameType() == TimeFrameType.FIXED);
            this.radioFixedInterval.addSelectionListener(listener);
        }
        Composite timeFixedGroup = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 4;
        timeFixedGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 128;
        timeFixedGroup.setLayoutData((Object)gd);
        WidgetFactory factory = new WidgetFactory(){

            @Override
            public Control createControl(Composite parent, int style) {
                return new DateTimeSelector(parent, style);
            }
        };
        Messages.get();
        this.timeFrom = (DateTimeSelector)WidgetHelper.createLabeledControl(timeFixedGroup, 0, factory, Messages.TimePeriodSelector_8, "WidgetHelper::default_layout_data");
        this.timeFrom.setEnabled(this.radioFixedInterval.getSelection());
        Messages.get();
        this.timeTo = (DateTimeSelector)WidgetHelper.createLabeledControl(timeFixedGroup, 0, factory, Messages.TimePeriodSelector_9, "WidgetHelper::default_layout_data");
        this.timeTo.setEnabled(this.radioFixedInterval.getSelection());
        this.setTimePeriod(period);
    }

    public void setTimePeriod(TimePeriod period) {
        this.radioBackFromNow.setSelection(period.getTimeFrameType() == TimeFrameType.BACK_FROM_NOW);
        this.radioFixedInterval.setSelection(period.getTimeFrameType() == TimeFrameType.FIXED);
        this.timeRange.setSelection(period.getTimeRange());
        this.timeRange.setEnabled(this.radioBackFromNow.getSelection());
        this.timeUnits.select(period.getTimeUnit().getValue());
        this.timeUnits.setEnabled(this.radioBackFromNow.getSelection());
        this.timeFrom.setValue(period.getTimeFrom());
        this.timeFrom.setEnabled(this.radioFixedInterval.getSelection());
        this.timeTo.setValue(period.getTimeTo());
        this.timeTo.setEnabled(this.radioFixedInterval.getSelection());
    }

    public TimePeriod getTimePeriod() {
        TimePeriod tp = new TimePeriod();
        tp.setTimeFrameType(this.radioBackFromNow.getSelection() ? TimeFrameType.BACK_FROM_NOW : TimeFrameType.FIXED);
        tp.setTimeRange(this.timeRange.getSelection());
        tp.setTimeUnit(TimeUnit.getByValue((int)this.timeUnits.getSelectionIndex()));
        tp.setTimeFrom(this.timeFrom.getValue());
        tp.setTimeTo(this.timeTo.getValue());
        return tp;
    }

    public TimeFrameType getTimeFrameType() {
        return this.radioBackFromNow.getSelection() ? TimeFrameType.BACK_FROM_NOW : TimeFrameType.FIXED;
    }

    public int getTimeRange() {
        return this.timeRange.getSelection();
    }

    public TimeUnit getTimeUnit() {
        return TimeUnit.getByValue((int)this.timeUnits.getSelectionIndex());
    }

    public Date getTimeFrom() {
        return this.timeFrom.getValue();
    }

    public Date getTimeTo() {
        return this.timeTo.getValue();
    }

    public void setDefaults() {
        this.radioBackFromNow.setSelection(true);
        this.radioFixedInterval.setSelection(false);
        this.timeRange.setSelection(60);
        this.timeRange.setEnabled(true);
        this.timeUnits.select(0);
        this.timeUnits.setEnabled(true);
        this.timeFrom.setEnabled(false);
        this.timeTo.setEnabled(false);
    }
}

