/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.logviewer.widgets;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.netxms.client.constants.ColumnFilterSetOperation;
import org.netxms.client.log.ColumnFilter;
import org.netxms.client.log.Log;
import org.netxms.client.log.LogColumn;
import org.netxms.client.log.LogFilter;
import org.netxms.client.log.OrderingColumn;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.logviewer.Messages;
import org.netxms.ui.eclipse.logviewer.widgets.ColumnFilterEditor;
import org.netxms.ui.eclipse.logviewer.widgets.helpers.ColumnSelectionHandler;
import org.netxms.ui.eclipse.logviewer.widgets.helpers.OrderingColumnEditingSupport;
import org.netxms.ui.eclipse.logviewer.widgets.helpers.OrderingListLabelProvider;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.Section;
import org.netxms.ui.eclipse.widgets.helpers.ExpansionEvent;
import org.netxms.ui.eclipse.widgets.helpers.ExpansionListener;

public class FilterBuilder
extends Composite {
    private Log logHandle = null;
    private Map<String, ColumnFilterEditor> columns = new HashMap<String, ColumnFilterEditor>();
    private List<OrderingColumn> orderingColumns = new ArrayList<OrderingColumn>();
    private ScrolledComposite scroller;
    private Composite content;
    private Section condition;
    private Section ordering;
    private ImageHyperlink addColumnLink;
    private TableViewer orderingList;
    private Menu columnSelectionMenu = null;

    public FilterBuilder(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.scroller = new ScrolledComposite((Composite)this, 512);
        this.scroller.setExpandHorizontal(true);
        this.scroller.setExpandVertical(true);
        WidgetHelper.setScrollBarIncrement((Scrollable)this.scroller, (int)512, (int)20);
        this.scroller.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                FilterBuilder.this.content.layout(true, true);
                FilterBuilder.this.scroller.setMinSize(FilterBuilder.this.content.computeSize(FilterBuilder.this.scroller.getSize().x, -1));
            }
        });
        this.content = new Composite((Composite)this.scroller, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.content.setLayout((Layout)layout);
        this.content.setBackground(this.content.getDisplay().getSystemColor(25));
        this.scroller.setContent((Control)this.content);
        this.createConditionSection();
        this.createOrderingSection();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (FilterBuilder.this.columnSelectionMenu != null) {
                    FilterBuilder.this.columnSelectionMenu.dispose();
                }
            }
        });
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size = this.content.computeSize(wHint, hHint, changed);
        if (size.y > 600) {
            size.y = 600;
        }
        return size;
    }

    private void createConditionSection() {
        Messages.get();
        this.condition = new Section(this.content, Messages.FilterBuilder_Condition, true);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 128;
        this.condition.setLayoutData((Object)gd);
        this.condition.addExpansionListener(new ExpansionListener(){

            public void expansionStateChanged(ExpansionEvent e) {
                FilterBuilder.this.updateLayout();
            }
        });
        Composite clientArea = this.condition.getClient();
        GridLayout layout = new GridLayout();
        clientArea.setLayout((Layout)layout);
        this.addColumnLink = new ImageHyperlink(clientArea, 0);
        Messages.get();
        this.addColumnLink.setText(Messages.FilterBuilder_AddColumn);
        this.addColumnLink.setImage(SharedIcons.IMG_ADD_OBJECT);
        this.addColumnLink.setBackground(clientArea.getBackground());
        this.addColumnLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                FilterBuilder.this.addColumnToFilter((Control)FilterBuilder.this.addColumnLink);
            }
        });
    }

    private void createOrderingSection() {
        Messages.get();
        this.ordering = new Section(this.content, Messages.FilterBuilder_Ordering, true);
        GridData gd = new GridData();
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 128;
        gd.horizontalAlignment = 4;
        gd.widthHint = 400;
        this.ordering.setLayoutData((Object)gd);
        this.ordering.addExpansionListener(new ExpansionListener(){

            public void expansionStateChanged(ExpansionEvent e) {
                FilterBuilder.this.updateLayout();
            }
        });
        Composite clientArea = this.ordering.getClient();
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        clientArea.setLayout((Layout)layout);
        this.orderingList = new TableViewer(clientArea, 68354);
        TableViewerColumn column = new TableViewerColumn(this.orderingList, 16384);
        TableColumn tableColumn = column.getColumn();
        Messages.get();
        tableColumn.setText(Messages.FilterBuilder_Column);
        column.getColumn().setWidth(200);
        column = new TableViewerColumn(this.orderingList, 16384);
        TableColumn tableColumn2 = column.getColumn();
        Messages.get();
        tableColumn2.setText(Messages.FilterBuilder_Descending);
        column.getColumn().setWidth(60);
        column.setEditingSupport((EditingSupport)new OrderingColumnEditingSupport((ColumnViewer)this.orderingList));
        this.orderingList.getTable().setLinesVisible(true);
        this.orderingList.getTable().setHeaderVisible(true);
        this.orderingList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.orderingList.setLabelProvider((IBaseLabelProvider)new OrderingListLabelProvider());
        this.orderingList.setInput((Object)this.orderingColumns.toArray());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 128;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.verticalSpan = 2;
        this.orderingList.getControl().setLayoutData((Object)gd);
        ImageHyperlink linkAdd = new ImageHyperlink(clientArea, 0);
        Messages.get();
        linkAdd.setText(Messages.FilterBuilder_Add);
        linkAdd.setImage(SharedIcons.IMG_ADD_OBJECT);
        linkAdd.setBackground(clientArea.getBackground());
        linkAdd.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                FilterBuilder.this.addOrderingColumn();
            }
        });
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkAdd.setLayoutData((Object)gd);
        final ImageHyperlink linkRemove = new ImageHyperlink(clientArea, 0);
        Messages.get();
        linkRemove.setText(Messages.FilterBuilder_Remove);
        linkRemove.setImage(SharedIcons.IMG_DELETE_OBJECT);
        linkRemove.setBackground(clientArea.getBackground());
        linkRemove.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                FilterBuilder.this.removeSortingColumn();
            }
        });
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkRemove.setLayoutData((Object)gd);
        linkRemove.setEnabled(false);
        this.orderingList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                linkRemove.setEnabled(!FilterBuilder.this.orderingList.getSelection().isEmpty());
            }
        });
    }

    public void clearFilter() {
        this.orderingColumns.clear();
        this.orderingList.setInput((Object)this.orderingColumns.toArray());
        for (ColumnFilterEditor e : this.columns.values()) {
            e.dispose();
        }
        this.columns.clear();
        this.updateLayout();
    }

    public void addOrderingColumn(LogColumn column, boolean descending) {
        OrderingColumn orderingColumn = new OrderingColumn(column);
        if (!this.orderingColumns.contains(orderingColumn)) {
            orderingColumn.setDescending(descending);
            this.orderingColumns.add(orderingColumn);
            this.orderingList.setInput((Object)this.orderingColumns.toArray());
        }
    }

    private void addOrderingColumn() {
        this.createColumnSelectionMenu(new ColumnSelectionHandler(){

            @Override
            public void columnSelected(LogColumn column) {
                OrderingColumn orderingColumn = new OrderingColumn(column);
                if (!FilterBuilder.this.orderingColumns.contains(orderingColumn)) {
                    FilterBuilder.this.orderingColumns.add(orderingColumn);
                    FilterBuilder.this.orderingList.setInput((Object)FilterBuilder.this.orderingColumns.toArray());
                    FilterBuilder.this.updateLayout();
                } else {
                    FilterBuilder.this.orderingList.setSelection((ISelection)new StructuredSelection((Object)column));
                }
            }
        });
    }

    private void removeSortingColumn() {
        IStructuredSelection selection = (IStructuredSelection)this.orderingList.getSelection();
        for (Object o : selection.toList()) {
            this.orderingColumns.remove(o);
        }
        this.orderingList.setInput((Object)this.orderingColumns.toArray());
        this.updateLayout();
    }

    public void setLogHandle(Log logHandle) {
        this.logHandle = logHandle;
        this.updateLayout();
    }

    private void addColumnToFilter(final Control lastControl) {
        this.createColumnSelectionMenu(new ColumnSelectionHandler(){

            @Override
            public void columnSelected(LogColumn column) {
                if (FilterBuilder.this.columns.get(column.getName()) != null) {
                    return;
                }
                FilterBuilder.this.createColumnFilterEditor(column, lastControl, null);
                FilterBuilder.this.updateLayout();
            }
        });
    }

    private void createColumnFilterEditor(final LogColumn column, Control lastControl, ColumnFilter initialFilter) {
        ColumnFilterEditor editor = new ColumnFilterEditor(this.condition.getClient(), column, initialFilter != null ? initialFilter.getOperation() : ColumnFilterSetOperation.AND, new Runnable(){

            @Override
            public void run() {
                FilterBuilder.this.columns.remove(column.getName());
                FilterBuilder.this.updateLayout();
            }
        });
        editor.attachFilterBuilder(this, initialFilter);
        editor.moveAbove(lastControl);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        editor.setLayoutData(gd);
        this.columns.put(column.getName(), editor);
    }

    private void createColumnSelectionMenu(final ColumnSelectionHandler handler) {
        if (this.logHandle == null) {
            return;
        }
        if (this.columnSelectionMenu != null) {
            this.columnSelectionMenu.dispose();
        }
        this.columnSelectionMenu = new Menu((Decorations)this.getShell(), 8);
        this.getShell().setMenu(this.columnSelectionMenu);
        for (final LogColumn lc : this.logHandle.getColumns()) {
            MenuItem item = new MenuItem(this.columnSelectionMenu, 8);
            item.setText(lc.getDescription());
            item.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    handler.columnSelected(lc);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
        }
        this.columnSelectionMenu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent e) {
            }

            public void menuHidden(MenuEvent e) {
                FilterBuilder.this.getShell().setMenu(null);
            }
        });
        this.columnSelectionMenu.setVisible(true);
    }

    public LogFilter createFilter() {
        LogFilter filter = new LogFilter();
        for (Map.Entry<String, ColumnFilterEditor> e : this.columns.entrySet()) {
            ColumnFilter cf = e.getValue().buildFilterTree();
            if (cf == null) continue;
            filter.setColumnFilter(e.getKey(), cf);
        }
        filter.setOrderingColumns(new ArrayList<OrderingColumn>(this.orderingColumns));
        return filter;
    }

    public void updateLayout() {
        this.getParent().layout(true, true);
        this.scroller.setMinSize(this.content.computeSize(this.scroller.getSize().x, -1));
    }

    public void setFilter(LogFilter filter) {
        this.clearFilter();
        for (Map.Entry cf : filter.getColumnFilters()) {
            this.createColumnFilterEditor(this.logHandle.getColumn((String)cf.getKey()), (Control)this.addColumnLink, (ColumnFilter)cf.getValue());
        }
        this.orderingColumns.addAll(filter.getOrderingColumns());
        this.orderingList.setInput((Object)this.orderingColumns.toArray());
        this.updateLayout();
    }
}

