/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.charts.api;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.RGB;
import org.netxms.ui.eclipse.charts.Activator;

public final class ChartColor {
    public int red;
    public int green;
    public int blue;
    public int alpha;

    public ChartColor(int red, int green, int blue, int alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
    }

    public ChartColor(int red, int green, int blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = 255;
    }

    public ChartColor(int rgb) {
        this.red = rgb & 0xFF;
        this.green = rgb >> 8 & 0xFF;
        this.blue = rgb >> 16;
        this.alpha = 255;
    }

    public ChartColor(RGB rgb) {
        this.red = rgb.red;
        this.green = rgb.green;
        this.blue = rgb.blue;
        this.alpha = 255;
    }

    public int getRGB() {
        return this.red & 0xFF | (this.green & 0xFF) << 8 | (this.blue & 0xFF) << 16;
    }

    public int getRGBA() {
        return this.red & 0xFF | (this.green & 0xFF) << 8 | (this.blue & 0xFF) << 16 | (this.alpha & 0xFF) << 24;
    }

    public RGB getRGBObject() {
        return new RGB(this.red, this.green, this.blue);
    }

    public static ChartColor createFromPreferences(IPreferenceStore preferenceStore, String name) {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)preferenceStore, (String)name);
        return new ChartColor(rgb.red, rgb.green, rgb.blue);
    }

    public static ChartColor getDefaultColor(int index) {
        return new ChartColor(PreferenceConverter.getColor((IPreferenceStore)Activator.getDefault().getPreferenceStore(), (String)("Chart.Colors.Data." + index)));
    }
}

