/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objecttools.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.objecttools.ObjectToolTableColumn;
import org.netxms.client.snmp.SnmpObjectId;
import org.netxms.client.snmp.SnmpObjectIdFormatException;
import org.netxms.ui.eclipse.objecttools.Messages;
import org.netxms.ui.eclipse.snmp.dialogs.MibSelectionDialog;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class EditColumnDialog
extends Dialog {
    private final String[] formatNames;
    private boolean create;
    private boolean snmpColumn;
    private ObjectToolTableColumn columnObject;
    private LabeledText name;
    private Combo format;
    private LabeledText data;
    private Button selectButton;

    public EditColumnDialog(Shell parentShell, boolean create, boolean snmpColumn, ObjectToolTableColumn columnObject) {
        super(parentShell);
        String[] stringArray = new String[6];
        Messages.get();
        stringArray[0] = Messages.EditColumnDialog_FmtString;
        Messages.get();
        stringArray[1] = Messages.EditColumnDialog_FmtInt;
        Messages.get();
        stringArray[2] = Messages.EditColumnDialog_FmtFloat;
        Messages.get();
        stringArray[3] = Messages.EditColumnDialog_FmtIpAddr;
        Messages.get();
        stringArray[4] = Messages.EditColumnDialog_FmtMacAddr;
        Messages.get();
        stringArray[5] = Messages.EditColumnDialog_FmtIfIndex;
        this.formatNames = stringArray;
        this.create = create;
        this.snmpColumn = snmpColumn;
        this.columnObject = columnObject;
    }

    protected void configureShell(Shell newShell) {
        String string;
        super.configureShell(newShell);
        if (this.create) {
            Messages.get();
            string = Messages.EditColumnDialog_CreateColumn;
        } else {
            Messages.get();
            string = Messages.EditColumnDialog_EditColumn;
        }
        newShell.setText(string);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        this.name = new LabeledText(dialogArea, 0);
        Messages.get();
        this.name.setLabel(Messages.EditColumnDialog_Name);
        this.name.setText(this.columnObject.getName());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 350;
        this.name.setLayoutData((Object)gd);
        Messages.get();
        this.format = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)Messages.EditColumnDialog_Format, (Object)"WidgetHelper::default_layout_data");
        int i = 0;
        while (i < this.formatNames.length) {
            this.format.add(this.formatNames[i]);
            ++i;
        }
        this.format.select(this.columnObject.getFormat());
        Composite dataGroup = null;
        if (this.snmpColumn) {
            dataGroup = new Composite(dialogArea, 0);
            layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.horizontalSpacing = 2;
            layout.numColumns = 2;
            dataGroup.setLayout((Layout)layout);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            dataGroup.setLayoutData((Object)gd);
        }
        this.data = new LabeledText(this.snmpColumn ? dataGroup : dialogArea, 0);
        if (this.snmpColumn) {
            Messages.get();
            this.data.setLabel(Messages.EditColumnDialog_SNMP_OID);
            this.data.setText(this.columnObject.getSnmpOid());
        } else {
            Messages.get();
            this.data.setLabel(Messages.EditColumnDialog_SubstrIndex);
            this.data.setText(Integer.toString(this.columnObject.getSubstringIndex()));
        }
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 350;
        this.data.setLayoutData((Object)gd);
        if (this.snmpColumn) {
            this.selectButton = new Button(dataGroup, 8);
            this.selectButton.setText("...");
            gd = new GridData();
            gd.verticalAlignment = 1024;
            this.selectButton.setLayoutData((Object)gd);
            this.selectButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    SnmpObjectId initial;
                    try {
                        initial = SnmpObjectId.parseSnmpObjectId((String)EditColumnDialog.this.data.getText());
                    }
                    catch (SnmpObjectIdFormatException ex) {
                        initial = null;
                    }
                    MibSelectionDialog dlg = new MibSelectionDialog(EditColumnDialog.this.getShell(), initial, 0L);
                    if (dlg.open() == 0) {
                        EditColumnDialog.this.data.setText(dlg.getSelectedObjectId().toString());
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
        }
        return dialogArea;
    }

    protected void okPressed() {
        if (this.snmpColumn) {
            this.columnObject.setSnmpOid(this.data.getText());
        } else {
            try {
                int n = Integer.parseInt(this.data.getText());
                this.columnObject.setSubstringIndex(n);
            }
            catch (NumberFormatException e) {
                Shell shell = this.getShell();
                Messages.get();
                Messages.get();
                MessageDialogHelper.openWarning((Shell)shell, (String)Messages.EditColumnDialog_Warning, (String)Messages.EditColumnDialog_EnterValidIndex);
                return;
            }
        }
        this.columnObject.setFormat(this.format.getSelectionIndex());
        this.columnObject.setName(this.name.getText().trim());
        super.okPressed();
    }
}

