/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.osm.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.base.GeoLocation;
import org.netxms.base.GeoLocationFormatException;
import org.netxms.client.GeoArea;
import org.netxms.ui.eclipse.osm.Activator;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class GeoAreaEditDialog
extends Dialog {
    private GeoArea area;
    private LabeledText name;
    private LabeledText comments;
    private LabeledText border;

    public GeoAreaEditDialog(Shell parentShell, GeoArea area) {
        super(parentShell);
        this.area = area;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.area != null ? "Edit Geographical Area" : "Create Geographical Area");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        dialogArea.setLayout((Layout)layout);
        this.name = new LabeledText(dialogArea, 0);
        this.name.setLabel("Name");
        this.name.getTextControl().setTextLimit(127);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 600;
        this.name.setLayoutData((Object)gd);
        this.comments = new LabeledText(dialogArea, 0, 2050);
        this.comments.setLabel("Comments");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.heightHint = 150;
        this.comments.setLayoutData((Object)gd);
        this.border = new LabeledText(dialogArea, 0, 2050);
        this.border.setLabel("Border points (one point per line)");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.heightHint = 250;
        this.border.setLayoutData((Object)gd);
        if (this.area != null) {
            this.name.setText(this.area.getName());
            this.comments.setText(this.area.getComments());
            this.border.setText(GeoAreaEditDialog.borderPointsToText(this.area.getBorder()));
        }
        return dialogArea;
    }

    private static String borderPointsToText(List<GeoLocation> borderPoints) {
        StringBuilder sb = new StringBuilder();
        for (GeoLocation p : borderPoints) {
            sb.append(p.getLatitudeAsString());
            sb.append(' ');
            sb.append(p.getLongitudeAsString());
            sb.append("\r\n");
        }
        return sb.toString();
    }

    protected void okPressed() {
        if (this.name.getText().trim().isEmpty()) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Area name cannot be empty!");
            return;
        }
        ArrayList<GeoLocation> borderPoints = new ArrayList<GeoLocation>();
        String[] stringArray = this.border.getText().split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            try {
                GeoLocation p = GeoLocation.parseGeoLocation((String)line.trim());
                borderPoints.add(p);
            }
            catch (GeoLocationFormatException e) {
                Activator.log("Exception while parsing area border points", (Exception)((Object)e));
                MessageDialogHelper.openWarning((Shell)this.getShell(), (String)"Warning", (String)String.format("Cannot parse area border point %s", line.trim()));
                return;
            }
            ++n2;
        }
        this.area = new GeoArea(this.area != null ? this.area.getId() : 0, this.name.getText().trim(), this.comments.getText(), borderPoints);
        super.okPressed();
    }

    public GeoArea getArea() {
        return this.area;
    }
}

