/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.osm.dialogs;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.GeoArea;
import org.netxms.client.NXCSession;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.osm.Activator;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class GeoAreaSelectionDialog
extends Dialog {
    private static final String TABLE_CONFIG_PREFIX = "GeoAreaSelectionDialog";
    private List<GeoArea> cachedAreaList;
    private TableViewer viewer;
    private int areaId = 0;

    public GeoAreaSelectionDialog(Shell parentShell, List<GeoArea> cachedAreaList) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.cachedAreaList = cachedAreaList;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Select Geo Area");
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        try {
            newShell.setSize(settings.getInt("GeoAreaSelectionDialog.cx"), settings.getInt("GeoAreaSelectionDialog.cy"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        dialogArea.setLayout((Layout)new FillLayout());
        this.viewer = new TableViewer(dialogArea, 67584);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((GeoArea)e1).getName().compareToIgnoreCase(((GeoArea)e2).getName());
            }
        });
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((GeoArea)element).getName();
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                GeoAreaSelectionDialog.this.okPressed();
            }
        });
        if (this.cachedAreaList != null) {
            this.viewer.setInput(this.cachedAreaList);
        } else {
            final NXCSession session = ConsoleSharedData.getSession();
            ConsoleJob job = new ConsoleJob("Read configured geographical areas", null, "org.netxms.ui.eclipse.osm", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    final List areas = session.getGeoAreas();
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            (this).GeoAreaSelectionDialog.this.viewer.setInput((Object)areas);
                        }
                    });
                }

                protected String getErrorMessage() {
                    return "Cannot get configured geographical areas";
                }
            };
            job.setUser(false);
            job.start();
        }
        return dialogArea;
    }

    protected void okPressed() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        this.areaId = selection.isEmpty() ? 0 : ((GeoArea)selection.getFirstElement()).getId();
        super.okPressed();
    }

    public int getAreaId() {
        return this.areaId;
    }
}

