/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.osm.tools;

import org.netxms.base.GeoLocation;

public class Area {
    private double xLow;
    private double yLow;
    private double xHigh;
    private double yHigh;

    public Area(double xLow, double yLow, double xHigh, double yHigh) {
        if (xLow < xHigh) {
            this.xLow = xLow;
            this.xHigh = xHigh;
        } else {
            this.xLow = xHigh;
            this.xHigh = xLow;
        }
        if (yLow < yHigh) {
            this.yLow = yLow;
            this.yHigh = yHigh;
        } else {
            this.yLow = yHigh;
            this.yHigh = yLow;
        }
    }

    public Area(GeoLocation topLeft, GeoLocation bottomRight) {
        this(topLeft.getLatitude(), topLeft.getLongitude(), bottomRight.getLatitude(), bottomRight.getLongitude());
    }

    public double getxLow() {
        return this.xLow;
    }

    public double getyLow() {
        return this.yLow;
    }

    public double getxHigh() {
        return this.xHigh;
    }

    public double getyHigh() {
        return this.yHigh;
    }

    public boolean contains(double x, double y) {
        return x >= this.xLow && x <= this.xHigh && y >= this.yLow && y <= this.yHigh;
    }

    public boolean contains(GeoLocation p) {
        return this.contains(p.getLatitude(), p.getLongitude());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Area={");
        sb.append(this.xLow);
        sb.append(',');
        sb.append(this.yLow);
        sb.append('/');
        sb.append(this.xHigh);
        sb.append(',');
        sb.append(this.yHigh);
        sb.append('}');
        return sb.toString();
    }
}

