/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.osm.tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netxms.ui.eclipse.osm.tools.Area;

public class QuadTree<Value> {
    private Node root;
    private Map<Value, Node> nodeMap = new HashMap<Value, Node>();

    public void insert(double x, double y, Value value) {
        this.root = this.insert(this.root, null, x, y, value);
    }

    private Node insert(Node n, Node parent, double x, double y, Value value) {
        if (n == null) {
            Node nn = new Node(x, y, value, parent);
            this.nodeMap.put(value, nn);
            return nn;
        }
        if (x < n.x && y < n.y) {
            n.SW = this.insert(n.SW, n, x, y, value);
        } else if (x < n.x && y >= n.y) {
            n.NW = this.insert(n.NW, n, x, y, value);
        } else if (x >= n.x && y < n.y) {
            n.SE = this.insert(n.SE, n, x, y, value);
        } else if (x >= n.x && y >= n.y) {
            n.NE = this.insert(n.NE, n, x, y, value);
        }
        return n;
    }

    public List<Value> query(Area area) {
        ArrayList result = new ArrayList();
        this.query(this.root, result, area);
        return result;
    }

    private void query(Node n, List<Value> result, Area area) {
        if (n == null) {
            return;
        }
        if (area.contains(n.x, n.y)) {
            result.add(n.value);
        }
        if (area.getxLow() < n.x && area.getyLow() < n.y) {
            this.query(n.SW, result, area);
        }
        if (area.getxLow() < n.x && area.getyHigh() >= n.y) {
            this.query(n.NW, result, area);
        }
        if (area.getxHigh() >= n.x && area.getyLow() < n.y) {
            this.query(n.SE, result, area);
        }
        if (area.getxHigh() >= n.x && area.getyHigh() >= n.y) {
            this.query(n.NE, result, area);
        }
    }

    public void removeAll() {
        this.root = null;
        this.nodeMap.clear();
    }

    public boolean remove(Value value) {
        Node n = this.nodeMap.remove(value);
        if (n == null) {
            return false;
        }
        if (n.parent != null) {
            n.parent.remove(n);
        } else {
            this.root = null;
        }
        this.reinsertChildren(n);
        return true;
    }

    private void reinsertChildren(Node n) {
        if (n.NW != null) {
            this.insert(n.NW.x, n.NW.y, n.NW.value);
            this.reinsertChildren(n.NW);
        }
        if (n.NE != null) {
            this.insert(n.NE.x, n.NE.y, n.NE.value);
            this.reinsertChildren(n.NE);
        }
        if (n.SW != null) {
            this.insert(n.SW.x, n.SW.y, n.SW.value);
            this.reinsertChildren(n.SW);
        }
        if (n.SE != null) {
            this.insert(n.SE.x, n.SE.y, n.SE.value);
            this.reinsertChildren(n.SE);
        }
    }

    private class Node {
        double x;
        double y;
        Node parent;
        Node NW;
        Node NE;
        Node SW;
        Node SE;
        Value value;

        Node(double x, double y, Value value, Node parent) {
            this.x = x;
            this.y = y;
            this.value = value;
            this.parent = parent;
        }

        void remove(Node n) {
            if (n == this.NW) {
                this.NW = null;
            } else if (n == this.NE) {
                this.NE = null;
            } else if (n == this.SW) {
                this.SW = null;
            } else if (n == this.SE) {
                this.SE = null;
            }
        }
    }
}

