/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.osm.widgets;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.base.GeoLocation;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.osm.GeoLocationCache;
import org.netxms.ui.eclipse.osm.GeoLocationCacheListener;
import org.netxms.ui.eclipse.osm.Messages;
import org.netxms.ui.eclipse.osm.tools.Area;
import org.netxms.ui.eclipse.osm.tools.MapAccessor;
import org.netxms.ui.eclipse.osm.tools.MapLoader;
import org.netxms.ui.eclipse.osm.tools.Tile;
import org.netxms.ui.eclipse.osm.tools.TileSet;
import org.netxms.ui.eclipse.osm.widgets.helpers.GeoMapListener;
import org.netxms.ui.eclipse.tools.ColorCache;
import org.netxms.ui.eclipse.tools.FontTools;

public abstract class AbstractGeoMapViewer
extends Canvas
implements PaintListener,
GeoLocationCacheListener,
MouseWheelListener,
MouseListener,
MouseMoveListener {
    protected static final Color BORDER_COLOR = new Color((Device)Display.getCurrent(), 0, 0, 0);
    protected static final int LABEL_ARROW_HEIGHT = 20;
    protected static final int LABEL_X_MARGIN = 12;
    protected static final int LABEL_Y_MARGIN = 12;
    protected static final int LABEL_SPACING = 4;
    protected static final Color SELECTION_COLOR = new Color((Device)Display.getCurrent(), 0, 0, 255);
    private static final int DRAG_JITTER = 8;
    private static final int BUTTON_MARGIN_WIDTH = 10;
    private static final int BUTTON_MARGIN_HEIGHT = 5;
    private static final int BUTTON_BLOCK_MARGIN_WIDTH = 10;
    private static final int BUTTON_BLOCK_MARGIN_HEIGHT = 15;
    protected ColorCache colorCache;
    protected ILabelProvider labelProvider;
    protected Area coverage = new Area(0.0, 0.0, 0.0, 0.0);
    protected MapAccessor accessor = new MapAccessor(0.0, 0.0, 4);
    protected IViewPart viewPart = null;
    protected Point currentPoint;
    private Image currentImage = null;
    private Image bufferImage = null;
    private MapLoader mapLoader;
    private Point dragStartPoint = null;
    private Point selectionStartPoint = null;
    private Point selectionEndPoint = null;
    private Set<GeoMapListener> mapListeners = new HashSet<GeoMapListener>(0);
    private String title = null;
    private int offsetX;
    private int offsetY;
    private int contentVerticalOffset = 0;
    private TileSet currentTileSet = null;
    private Rectangle zoomControlRect = null;
    private Rectangle titleRect = null;
    private Font controlFont;
    private boolean enableControls = true;
    private boolean fullVerticalCoverage = false;

    public AbstractGeoMapViewer(Composite parent, int style) {
        super(parent, style | 0x40000 | 0x20000000);
        this.colorCache = new ColorCache((Control)this);
        this.controlFont = FontTools.createAdjustedFont((Font)JFaceResources.getTextFont(), (int)12, (int)1);
        this.labelProvider = WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider();
        this.mapLoader = new MapLoader(this.getDisplay());
        this.addPaintListener(this);
        final Runnable timer = new Runnable(){

            @Override
            public void run() {
                if (AbstractGeoMapViewer.this.isDisposed()) {
                    return;
                }
                AbstractGeoMapViewer.this.reloadMap();
            }
        };
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                AbstractGeoMapViewer.this.getDisplay().timerExec(-1, timer);
                AbstractGeoMapViewer.this.getDisplay().timerExec(1000, timer);
                if (AbstractGeoMapViewer.this.bufferImage != null) {
                    AbstractGeoMapViewer.this.bufferImage.dispose();
                }
                Rectangle rect = AbstractGeoMapViewer.this.getClientArea();
                AbstractGeoMapViewer.this.bufferImage = new Image((Device)AbstractGeoMapViewer.this.getDisplay(), rect.width, rect.height);
                AbstractGeoMapViewer.this.checkVerticalCoverage();
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                AbstractGeoMapViewer.this.labelProvider.dispose();
                GeoLocationCache.getInstance().removeListener(AbstractGeoMapViewer.this);
                if (AbstractGeoMapViewer.this.bufferImage != null) {
                    AbstractGeoMapViewer.this.bufferImage.dispose();
                }
                if (AbstractGeoMapViewer.this.currentImage != null) {
                    AbstractGeoMapViewer.this.currentImage.dispose();
                }
                AbstractGeoMapViewer.this.mapLoader.dispose();
                AbstractGeoMapViewer.this.controlFont.dispose();
            }
        });
        this.addMouseListener(this);
        this.addMouseMoveListener(this);
        this.addMouseWheelListener(this);
        GeoLocationCache.getInstance().addListener(this);
    }

    public void enableMapControls(boolean enable) {
        this.enableControls = enable;
        this.redraw();
    }

    public void addMapListener(GeoMapListener listener) {
        this.mapListeners.add(listener);
    }

    public void removeMapListener(GeoMapListener listener) {
        this.mapListeners.remove(listener);
    }

    private void notifyOnZoomChange() {
        for (GeoMapListener listener : this.mapListeners) {
            listener.onZoom(this.accessor.getZoom());
        }
    }

    private void notifyOnPositionChange() {
        for (GeoMapListener listener : this.mapListeners) {
            listener.onPan(this.accessor.getCenterPoint());
        }
    }

    public void showMap(MapAccessor accessor) {
        this.accessor = new MapAccessor(accessor);
        this.reloadMap();
    }

    public void showMap(double lat, double lon, int zoom) {
        this.showMap(new MapAccessor(lat, lon, zoom));
    }

    public void reloadMap() {
        Point size = this.getSize();
        Point virtualMapSize = GeoLocationCache.getVirtualMapSize(this.accessor.getZoom());
        if (virtualMapSize.y < size.y) {
            size.y = virtualMapSize.y;
        }
        this.accessor.setMapWidth(size.x);
        this.accessor.setMapHeight(size.y);
        if (this.currentImage != null) {
            this.currentImage.dispose();
        }
        this.currentImage = null;
        if (!this.accessor.isValid()) {
            return;
        }
        final Point mapSize = new Point(this.accessor.getMapWidth(), this.accessor.getMapHeight());
        final GeoLocation centerPoint = this.accessor.getCenterPoint();
        Messages.get();
        ConsoleJob job = new ConsoleJob(Messages.GeoMapViewer_DownloadJob_Title, (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.osm", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final TileSet tiles = AbstractGeoMapViewer.this.mapLoader.getAllTiles(mapSize, centerPoint, 0, AbstractGeoMapViewer.this.accessor.getZoom(), true);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (AbstractGeoMapViewer.this.isDisposed()) {
                            return;
                        }
                        (this).AbstractGeoMapViewer.this.currentTileSet = null;
                        if (tiles != null) {
                            AbstractGeoMapViewer.this.drawTiles(tiles);
                            AbstractGeoMapViewer.this.redraw();
                            if (tiles.missingTiles > 0) {
                                (this).AbstractGeoMapViewer.this.currentTileSet = tiles;
                                AbstractGeoMapViewer.this.loadMissingTiles(tiles);
                            } else {
                                tiles.dispose();
                            }
                        }
                        Point mapSize = new Point((this).AbstractGeoMapViewer.this.currentImage.getImageData().width, (this).AbstractGeoMapViewer.this.currentImage.getImageData().height);
                        (this).AbstractGeoMapViewer.this.coverage = GeoLocationCache.calculateCoverage(mapSize, (this).AbstractGeoMapViewer.this.accessor.getCenterPoint(), 0, (this).AbstractGeoMapViewer.this.accessor.getZoom());
                        AbstractGeoMapViewer.this.onMapLoad();
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.GeoMapViewer_DownloadError;
            }
        };
        job.setUser(false);
        job.start();
    }

    protected abstract void onMapLoad();

    private void loadMissingTiles(final TileSet tiles) {
        Messages.get();
        ConsoleJob job = new ConsoleJob(Messages.GeoMapViewer_LoadMissingJob_Title, (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.osm", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                AbstractGeoMapViewer.this.mapLoader.loadMissingTiles(tiles, new Runnable(){

                    @Override
                    public void run() {
                        if (!AbstractGeoMapViewer.this.isDisposed() && (this).AbstractGeoMapViewer.this.currentTileSet == tiles) {
                            AbstractGeoMapViewer.this.drawTiles(tiles);
                            AbstractGeoMapViewer.this.redraw();
                        } else {
                            tiles.cancelled = true;
                        }
                        if (tiles.missingTiles == 0) {
                            tiles.dispose();
                        }
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.GeoMapViewer_DownloadError;
            }
        };
        job.setUser(false);
        job.start();
    }

    private void drawTiles(TileSet tileSet) {
        if (this.currentImage != null) {
            this.currentImage.dispose();
        }
        if (tileSet == null || tileSet.tiles == null || tileSet.tiles.length == 0) {
            this.currentImage = null;
            return;
        }
        Tile[][] tiles = tileSet.tiles;
        Point size = this.getSize();
        Point virtualMapSize = GeoLocationCache.getVirtualMapSize(this.accessor.getZoom());
        if (size.y > virtualMapSize.y) {
            this.contentVerticalOffset = (size.y - virtualMapSize.y) / 2;
            size.y = virtualMapSize.y;
        }
        this.currentImage = new Image((Device)this.getDisplay(), size.x, size.y);
        GC gc = new GC((Drawable)this.currentImage);
        int x = tileSet.xOffset;
        int y = tileSet.yOffset;
        int i = 0;
        while (i < tiles.length) {
            int j = 0;
            while (j < tiles[i].length) {
                gc.drawImage(tiles[i][j].getImage(), x, y);
                if ((x += 256) >= size.x) {
                    x = tileSet.xOffset;
                    y += 256;
                }
                ++j;
            }
            ++i;
        }
        gc.dispose();
    }

    public void paintControl(PaintEvent e) {
        GeoLocation currentLocation;
        if (this.bufferImage == null) {
            e.gc.fillRectangle(this.getClientArea());
            return;
        }
        GC gc = new GC((Drawable)this.bufferImage);
        gc.setAntialias(1);
        gc.setTextAntialias(1);
        if (this.contentVerticalOffset > 0) {
            gc.setBackground(this.getDisplay().getSystemColor(22));
            Rectangle rect = this.getClientArea();
            rect.y = rect.height - this.contentVerticalOffset - 1;
            rect.height = this.contentVerticalOffset + 1;
            gc.fillRectangle(rect);
            rect.y = 0;
            gc.fillRectangle(rect);
        }
        if (this.dragStartPoint == null) {
            int imgH;
            int imgW;
            currentLocation = this.accessor.getCenterPoint();
            if (this.currentImage != null) {
                gc.drawImage(this.currentImage, -this.offsetX, this.contentVerticalOffset - this.offsetY);
                imgW = this.currentImage.getImageData().width;
                imgH = this.currentImage.getImageData().height;
            } else {
                imgW = -1;
                imgH = -1;
            }
            this.drawContent(gc, currentLocation, imgW, imgH, this.contentVerticalOffset);
        } else {
            Point cp = GeoLocationCache.coordinateToDisplay(this.accessor.getCenterPoint(), this.accessor.getZoom());
            cp.x += this.offsetX;
            cp.y += this.offsetY;
            currentLocation = GeoLocationCache.displayToCoordinates(cp, this.accessor.getZoom(), true);
            Point size = this.getSize();
            TileSet tileSet = this.mapLoader.getAllTiles(size, currentLocation, 0, this.accessor.getZoom(), true);
            int x = tileSet.xOffset;
            int y = tileSet.yOffset;
            Tile[][] tiles = tileSet.tiles;
            int i = 0;
            while (i < tiles.length) {
                int j = 0;
                while (j < tiles[i].length) {
                    gc.drawImage(tiles[i][j].getImage(), x, y + this.contentVerticalOffset);
                    if ((x += 256) >= size.x) {
                        x = tileSet.xOffset;
                        y += 256;
                    }
                    ++j;
                }
                ++i;
            }
            tileSet.dispose();
        }
        if (this.selectionStartPoint != null && this.selectionEndPoint != null) {
            int x = Math.min(this.selectionStartPoint.x, this.selectionEndPoint.x);
            int y = Math.min(this.selectionStartPoint.y, this.selectionEndPoint.y);
            int w = Math.abs(this.selectionStartPoint.x - this.selectionEndPoint.x);
            int h = Math.abs(this.selectionStartPoint.y - this.selectionEndPoint.y);
            gc.setBackground(SELECTION_COLOR);
            gc.setForeground(SELECTION_COLOR);
            gc.setAlpha(64);
            gc.fillRectangle(x, y, w, h);
            gc.setAlpha(255);
            gc.setLineWidth(2);
            gc.drawRectangle(x, y, w, h);
        }
        gc.setFont(null);
        String text = "Map data \u00a9 OpenStreetMap contributors\tZoom level " + this.accessor.getZoom() + "\tCentered at " + currentLocation.toString();
        Point infoTextSize = gc.textExtent(text);
        Rectangle infoTextRectangle = this.getClientArea();
        infoTextRectangle.x = infoTextRectangle.width - infoTextSize.x - 10;
        infoTextRectangle.y = infoTextRectangle.height - infoTextSize.y - 8;
        infoTextRectangle.width = infoTextSize.x + 11;
        infoTextRectangle.height = infoTextSize.y + 9;
        gc.setBackground(this.getDisplay().getSystemColor(22));
        gc.fillRectangle(infoTextRectangle.x, infoTextRectangle.y, infoTextRectangle.width, infoTextRectangle.height);
        gc.setForeground(this.getDisplay().getSystemColor(21));
        gc.drawText(text, infoTextRectangle.x + 5, infoTextRectangle.y + 4, true);
        if (this.title != null && !this.title.isEmpty()) {
            gc.setFont(JFaceResources.getBannerFont());
            Point size = gc.textExtent(this.title);
            Rectangle rect = this.getClientArea();
            rect.x = rect.width / 2 - size.x / 2 - 8;
            rect.y = 10;
            rect.width = size.x + 16;
            rect.height = size.y + 10;
            gc.setBackground(this.getDisplay().getSystemColor(25));
            gc.fillRoundRectangle(rect.x, rect.y, rect.width, rect.height, 8, 8);
            gc.setForeground(this.getDisplay().getSystemColor(23));
            gc.drawRoundRectangle(rect.x, rect.y, rect.width, rect.height, 8, 8);
            gc.setForeground(this.getDisplay().getSystemColor(24));
            gc.drawText(this.title, rect.x + 8, rect.y + 6);
            this.titleRect = rect;
        } else {
            this.titleRect = null;
        }
        if (this.enableControls) {
            gc.setFont(this.controlFont);
            Point buttonSize = gc.textExtent("+");
            buttonSize.x += 20;
            buttonSize.y += 10;
            Rectangle rect = this.getClientArea();
            rect.x = rect.width - buttonSize.x - 10;
            rect.y = rect.height - buttonSize.y * 2 - infoTextRectangle.height - 15;
            rect.width = buttonSize.x;
            rect.height = buttonSize.y * 2 + 1;
            gc.setBackground(this.getDisplay().getSystemColor(25));
            gc.fillRoundRectangle(rect.x, rect.y, rect.width, rect.height, 8, 8);
            gc.setForeground(this.getDisplay().getSystemColor(23));
            gc.drawRoundRectangle(rect.x, rect.y, rect.width, rect.height, 8, 8);
            gc.drawLine(rect.x, rect.y + buttonSize.y + 1, rect.x + rect.width, rect.y + buttonSize.y + 1);
            gc.setForeground(this.getDisplay().getSystemColor(24));
            gc.drawText("+", rect.x + 10, rect.y + 5, true);
            gc.drawText("-", rect.x + 10, rect.y + buttonSize.y + 5, true);
            this.zoomControlRect = rect;
        }
        gc.dispose();
        e.gc.drawImage(this.bufferImage, 0, 0);
    }

    protected abstract void drawContent(GC var1, GeoLocation var2, int var3, int var4, int var5);

    @Override
    public void geoLocationCacheChanged(final AbstractObject object, final GeoLocation prevLocation) {
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                AbstractGeoMapViewer.this.onCacheChange(object, prevLocation);
            }
        });
    }

    protected abstract void onCacheChange(AbstractObject var1, GeoLocation var2);

    public void mouseScrolled(MouseEvent e) {
        if (!this.enableControls) {
            return;
        }
        int zoom = this.accessor.getZoom();
        if (e.count > 0) {
            if (zoom < 19) {
                ++zoom;
            }
        } else if (zoom > 1) {
            Point virtualMapSize = GeoLocationCache.getVirtualMapSize(zoom);
            Point widgetSize = this.getSize();
            if (widgetSize.x < virtualMapSize.x || widgetSize.y < virtualMapSize.y) {
                --zoom;
            }
        }
        if (zoom != this.accessor.getZoom()) {
            Point pt = new Point(e.x, e.y);
            GeoLocation oldLocation = this.getLocationAtPoint(pt);
            Point mapSize = new Point(this.accessor.getMapWidth(), this.accessor.getMapHeight());
            Area newCoverage = GeoLocationCache.calculateCoverage(mapSize, this.accessor.getCenterPoint(), 0, zoom);
            Point cp = GeoLocationCache.coordinateToDisplay(new GeoLocation(newCoverage.getxHigh(), newCoverage.getyLow()), zoom);
            GeoLocation newLocation = GeoLocationCache.displayToCoordinates(new Point(cp.x + pt.x, cp.y + pt.y), zoom, true);
            this.accessor.setLatitude(this.accessor.getLatitude() - (newLocation.getLatitude() - oldLocation.getLatitude()));
            this.accessor.setLongitude(this.accessor.getLongitude() - (newLocation.getLongitude() - oldLocation.getLongitude()));
            this.accessor.setZoom(zoom);
            this.checkVerticalCoverage();
            this.reloadMap();
            this.notifyOnZoomChange();
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
        if (!this.enableControls || e.button != 1 || this.zoomControlRect.contains(e.x, e.y) || this.titleRect != null && this.titleRect.contains(e.x, e.y)) {
            return;
        }
        int zoom = this.accessor.getZoom();
        if (zoom < 19) {
            int step = (e.stateMask & 0x20000) != 0 ? 4 : 1;
            zoom = zoom + step > 19 ? 19 : zoom + step;
            GeoLocation geoLocation = this.getLocationAtPoint(new Point(e.x, e.y));
            this.accessor.setZoom(zoom);
            this.accessor.setLatitude(geoLocation.getLatitude());
            this.accessor.setLongitude(geoLocation.getLongitude());
            this.checkVerticalCoverage();
            this.reloadMap();
            this.notifyOnZoomChange();
            this.notifyOnPositionChange();
        }
    }

    public void mouseDown(MouseEvent e) {
        if (!this.enableControls) {
            return;
        }
        if (e.button == 1) {
            if (this.zoomControlRect.contains(e.x, e.y)) {
                Rectangle r = new Rectangle(this.zoomControlRect.x, this.zoomControlRect.y, this.zoomControlRect.width, this.zoomControlRect.height / 2);
                int zoom = this.accessor.getZoom();
                if (r.contains(e.x, e.y)) {
                    if (zoom < 19) {
                        ++zoom;
                    }
                } else {
                    r.y += this.zoomControlRect.height / 2 + 1;
                    if (r.contains(e.x, e.y) && zoom > 1) {
                        Point virtualMapSize = GeoLocationCache.getVirtualMapSize(zoom);
                        Point widgetSize = this.getSize();
                        if (widgetSize.x < virtualMapSize.x || widgetSize.y < virtualMapSize.y) {
                            --zoom;
                        }
                    }
                }
                if (zoom != this.accessor.getZoom()) {
                    this.accessor.setZoom(zoom);
                    this.checkVerticalCoverage();
                    this.reloadMap();
                    this.notifyOnZoomChange();
                }
            } else if (this.titleRect == null || !this.titleRect.contains(e.x, e.y)) {
                if ((e.stateMask & 0x20000) != 0) {
                    if (this.accessor.getZoom() < 19) {
                        this.selectionStartPoint = new Point(e.x, e.y);
                    }
                } else {
                    this.dragStartPoint = new Point(e.x, e.y);
                    this.setCursor(this.getDisplay().getSystemCursor(5));
                }
            }
        }
        this.currentPoint = new Point(e.x, e.y);
    }

    public void mouseUp(MouseEvent e) {
        if (e.button == 1 && this.dragStartPoint != null) {
            if (Math.abs(this.offsetX) > 8 || Math.abs(this.offsetY) > 8) {
                Point centerXY = GeoLocationCache.coordinateToDisplay(this.accessor.getCenterPoint(), this.accessor.getZoom());
                centerXY.x += this.offsetX;
                centerXY.y += this.offsetY;
                GeoLocation geoLocation = GeoLocationCache.displayToCoordinates(centerXY, this.accessor.getZoom(), true);
                this.accessor.setLatitude(geoLocation.getLatitude());
                this.accessor.setLongitude(geoLocation.getLongitude());
                this.reloadMap();
                this.notifyOnPositionChange();
            }
            this.offsetX = 0;
            this.offsetY = 0;
            this.dragStartPoint = null;
            this.setCursor(null);
        }
        if (e.button == 1 && this.selectionStartPoint != null) {
            if (this.selectionEndPoint != null) {
                int x1 = Math.min(this.selectionStartPoint.x, this.selectionEndPoint.x);
                int x2 = Math.max(this.selectionStartPoint.x, this.selectionEndPoint.x);
                int y1 = Math.min(this.selectionStartPoint.y, this.selectionEndPoint.y);
                int y2 = Math.max(this.selectionStartPoint.y, this.selectionEndPoint.y);
                GeoLocation l1 = this.getLocationAtPoint(new Point(x1, y1));
                GeoLocation l2 = this.getLocationAtPoint(new Point(x2, y2));
                GeoLocation lc = this.getLocationAtPoint(new Point(x2 - (x2 - x1) / 2, y2 - (y2 - y1) / 2));
                int zoom = this.accessor.getZoom();
                while (zoom < 19) {
                    Area area = GeoLocationCache.calculateCoverage(this.getSize(), lc, 0, ++zoom);
                    if (area.contains(l1.getLatitude(), l1.getLongitude()) && area.contains(l2.getLatitude(), l2.getLongitude())) continue;
                    --zoom;
                    break;
                }
                if (zoom != this.accessor.getZoom()) {
                    this.accessor.setZoom(zoom);
                    this.accessor.setLatitude(lc.getLatitude());
                    this.accessor.setLongitude(lc.getLongitude());
                    this.checkVerticalCoverage();
                    this.reloadMap();
                    this.notifyOnPositionChange();
                    this.notifyOnZoomChange();
                }
            }
            this.selectionStartPoint = null;
            this.selectionEndPoint = null;
            this.redraw();
        }
    }

    public void mouseMove(MouseEvent e) {
        int deltaY;
        int deltaX;
        if (this.dragStartPoint != null) {
            deltaX = this.dragStartPoint.x - e.x;
            int n = deltaY = this.fullVerticalCoverage ? 0 : this.dragStartPoint.y - e.y;
            if (Math.abs(deltaX) > 8 || Math.abs(deltaY) > 8) {
                this.offsetX = deltaX;
                this.offsetY = deltaY;
                this.redraw();
            }
        }
        if (this.selectionStartPoint != null) {
            deltaX = this.selectionStartPoint.x - e.x;
            deltaY = this.selectionStartPoint.y - e.y;
            if (Math.abs(deltaX) > 8 || Math.abs(deltaY) > 8) {
                this.selectionEndPoint = new Point(e.x, e.y);
                this.redraw();
            }
        }
    }

    public Point getCurrentPoint() {
        return new Point(this.currentPoint.x, this.currentPoint.y);
    }

    public GeoLocation getLocationAtPoint(Point p) {
        Point cp = GeoLocationCache.coordinateToDisplay(new GeoLocation(this.coverage.getxHigh(), this.coverage.getyLow()), this.accessor.getZoom());
        return GeoLocationCache.displayToCoordinates(new Point(cp.x + p.x, cp.y + p.y - this.contentVerticalOffset), this.accessor.getZoom(), true);
    }

    public IViewPart getViewPart() {
        return this.viewPart;
    }

    public void setViewPart(IViewPart viewPart) {
        this.viewPart = viewPart;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public abstract AbstractObject getObjectAtPoint(Point var1);

    private void checkVerticalCoverage() {
        Point size = this.getSize();
        Point virtualMapSize = GeoLocationCache.getVirtualMapSize(this.accessor.getZoom());
        if (size.y >= virtualMapSize.y) {
            this.fullVerticalCoverage = true;
            this.contentVerticalOffset = (size.y - virtualMapSize.y) / 2;
            this.accessor.setLatitude(0.0);
        } else {
            this.fullVerticalCoverage = false;
            this.contentVerticalOffset = 0;
        }
    }
}

