/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.nxsl.tools;

import java.util.ArrayList;
import java.util.LinkedList;
import org.eclipse.swt.custom.ExtendedModifyEvent;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;

public class NXSLLineStyleListener
implements LineStyleListener,
ExtendedModifyListener {
    private static final int STATE_DEFAULT = 0;
    private static final int STATE_COMMENT = 1;
    private static final int STATE_EOL_COMMENT = 2;
    private static final int STATE_STRING = 3;
    private static final Color COMMENT_COLOR = new Color((Device)Display.getCurrent(), 128, 128, 128);
    private static final Color CONSTANT_COLOR = new Color((Device)Display.getCurrent(), 0, 0, 192);
    private static final Color ERROR_COLOR = new Color((Device)Display.getCurrent(), 255, 255, 255);
    private static final Color ERROR_BK_COLOR = new Color((Device)Display.getCurrent(), 255, 0, 0);
    private static final Color KEYWORD_COLOR = new Color((Device)Display.getCurrent(), 96, 0, 0);
    private static final Color STRING_COLOR = new Color((Device)Display.getCurrent(), 0, 0, 192);
    private static final String[] keywords = new String[]{"abort", "array", "break", "case", "catch", "classof", "const", "continue", "default", "do", "else", "exit", "for", "foreach", "global", "if", "ilike", "imatch", "int32", "int64", "like", "match", "print", "println", "real", "return", "string", "sub", "switch", "try", "typeof", "uint32", "uint64", "use", "while"};
    private static final String[] systemConstants = new String[]{"null", "NULL", "true", "TRUE", "false", "FALSE"};
    private LinkedList commentOffsets = new LinkedList();

    private StyleRange newCommentStyle(int start, int length) {
        return new StyleRange(start, length, COMMENT_COLOR, null);
    }

    private StyleRange newKeywordStyle(int start, int length) {
        StyleRange style = new StyleRange(start, length, KEYWORD_COLOR, null);
        style.fontStyle = 1;
        return style;
    }

    private StyleRange newConstantStyle(int start, int length) {
        StyleRange style = new StyleRange(start, length, CONSTANT_COLOR, null);
        style.fontStyle = 2;
        return style;
    }

    private StyleRange newStringStyle(int start, int length) {
        return new StyleRange(start, length, STRING_COLOR, null);
    }

    private StyleRange newOpenStringStyle(int start, int length) {
        return new StyleRange(start, length, ERROR_COLOR, ERROR_BK_COLOR);
    }

    public void lineGetStyle(LineStyleEvent event) {
        ArrayList<StyleRange> styles = new ArrayList<StyleRange>();
        int state = this.isOffsetWithinComment(event.lineOffset) ? 1 : 0;
        int start = 0;
        StringBuilder word = new StringBuilder();
        int length = event.lineText.length();
        int i = 0;
        while (i < length) {
            char ch = event.lineText.charAt(i);
            block0 : switch (state) {
                case 0: {
                    int next;
                    switch (ch) {
                        case '/': {
                            int n = next = i < length - 1 ? (int)event.lineText.charAt(i + 1) : 0;
                            if (next == 42) {
                                this.processKeyword(word, event.lineOffset + start, styles);
                                state = 1;
                                start = i++;
                                break block0;
                            }
                            if (next != 47) break block0;
                            this.processKeyword(word, event.lineOffset + start, styles);
                            styles.add(this.newCommentStyle(event.lineOffset + i, length - i));
                            i = length;
                            state = 2;
                            break block0;
                        }
                        case '\"': {
                            this.processKeyword(word, event.lineOffset + start, styles);
                            state = 3;
                            start = i;
                            break block0;
                        }
                    }
                    if (Character.isLetter(ch)) {
                        if (word.length() == 0) {
                            start = i;
                        }
                        word.append(ch);
                        break;
                    }
                    this.processKeyword(word, event.lineOffset + start, styles);
                    break;
                }
                case 3: {
                    switch (ch) {
                        case '\\': {
                            ++i;
                            break;
                        }
                        case '\"': {
                            styles.add(this.newStringStyle(event.lineOffset + start, i - start + 1));
                            start = i + 1;
                            state = 0;
                        }
                    }
                    break;
                }
                case 1: {
                    int next;
                    if (ch != '*') break;
                    int n = next = i < length - 1 ? (int)event.lineText.charAt(i + 1) : 0;
                    if (next != 47) break;
                    styles.add(this.newCommentStyle(event.lineOffset + start, ++i - start + 1));
                    start = i + 1;
                    state = 0;
                }
            }
            ++i;
        }
        switch (state) {
            case 0: {
                this.processKeyword(word, event.lineOffset + start, styles);
                break;
            }
            case 1: {
                styles.add(this.newCommentStyle(event.lineOffset + start, length - start));
                break;
            }
            case 3: {
                styles.add(this.newOpenStringStyle(event.lineOffset + start, length - start));
            }
        }
        event.styles = styles.toArray(new StyleRange[styles.size()]);
    }

    private void processKeyword(StringBuilder word, int start, ArrayList<StyleRange> styles) {
        if (word.length() == 0) {
            return;
        }
        String s = word.toString();
        int i = 0;
        while (i < keywords.length) {
            if (s.compareTo(keywords[i]) == 0) {
                styles.add(this.newKeywordStyle(start, word.length()));
            }
            ++i;
        }
        i = 0;
        while (i < systemConstants.length) {
            if (s.compareTo(systemConstants[i]) == 0) {
                styles.add(this.newConstantStyle(start, word.length()));
            }
            ++i;
        }
        word.setLength(0);
    }

    public void modifyText(ExtendedModifyEvent event) {
        StyledText styledText = (StyledText)event.widget;
        this.refreshMultilineComments(styledText.getText());
        styledText.redraw();
    }

    private void refreshMultilineComments(String text) {
        this.commentOffsets.clear();
        int length = text.length();
        int state = 0;
        int[] offsets = null;
        int i = 0;
        while (i < length) {
            char ch = text.charAt(i);
            switch (state) {
                case 0: {
                    char next;
                    switch (ch) {
                        case '\"': {
                            state = 3;
                            break;
                        }
                        case '/': {
                            char c = next = i < length - 1 ? text.charAt(i + 1) : (char)'\u0000';
                            if (next == '*') {
                                offsets = new int[2];
                                offsets[0] = i++;
                                state = 1;
                                break;
                            }
                            if (next != '/') break;
                            state = 2;
                            ++i;
                        }
                    }
                    break;
                }
                case 3: {
                    switch (ch) {
                        case '\n': 
                        case '\r': 
                        case '\"': {
                            state = 0;
                            break;
                        }
                        case '\\': {
                            ++i;
                        }
                    }
                    break;
                }
                case 2: {
                    if (ch != '\r' && ch != '\n') break;
                    state = 0;
                    break;
                }
                case 1: {
                    char next;
                    if (ch != '*') break;
                    char c = next = i < length - 1 ? text.charAt(i + 1) : (char)'\u0000';
                    if (next != '/') break;
                    offsets[1] = ++i;
                    this.commentOffsets.add(offsets);
                    state = 0;
                }
            }
            ++i;
        }
        if (state == 1) {
            offsets[1] = length - 1;
            this.commentOffsets.add(offsets);
        }
    }

    public boolean isOffsetWithinComment(int offset) {
        int i = 0;
        while (i < this.commentOffsets.size()) {
            int[] offsets = (int[])this.commentOffsets.get(i);
            if (offsets[0] > offset) break;
            if (offsets[1] > offset) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String[] getSystemconstants() {
        return systemConstants;
    }
}

