/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.nxsl.widgets.internal;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class CodePatternRule
implements IPredicateRule {
    private IToken successToken;

    public CodePatternRule(IToken successToken) {
        this.successToken = successToken;
    }

    private int isCodePartEnd(char curr, char prev) {
        if (curr == '\"') {
            return 1;
        }
        if (prev == '/' && (curr == '*' || curr == '/')) {
            return 2;
        }
        return 0;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        int prev = -1;
        int curr = -1;
        int offset = 0;
        int chars = 0;
        do {
            prev = curr;
            curr = scanner.read();
            if (curr == -1) break;
            offset = this.isCodePartEnd((char)curr, (char)prev);
            ++chars;
        } while (offset == 0);
        int i = 0;
        while (i < offset) {
            scanner.unread();
            ++i;
        }
        return chars == 0 ? Token.UNDEFINED : this.successToken;
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        return this.evaluate(scanner);
    }

    public IToken getSuccessToken() {
        return this.successToken;
    }
}

