/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.snmp;

import java.util.HashMap;
import java.util.Map;

public class SnmpConstants {
    private static final String[] mibObjectStatus = new String[]{"", "Mandatory", "Optional", "Obsolete", "Deprecated", "Current"};
    private static final String[] mibObjectAccess = new String[]{"", "Read", "Read/Write", "Write", "None", "Notify", "Create"};
    private static final String[] mibObjectType = new String[]{"Other", "Import Item", "Object ID", "Bit String", "Integer", "Integer 32bits", "Integer 64bits", "Unsigned Int 32bits", "Counter", "Counter 32bits", "Counter 64bits", "Gauge", "Gauge 32bits", "Timeticks", "Octet String", "Opaque", "IP Address", "Physical Address", "Network Address", "Named Type", "Sequence ID", "Sequence", "Choice", "Textual Convention", "Macro", "MODCOMP", "Trap", "Notification", "Module ID", "NSAP Address", "Agent Capability", "Unsigned Integer", "Null", "Object Group", "Notification Group"};
    private static final Map<Integer, String> asnType = new HashMap<Integer, String>();

    static {
        asnType.put(2, "INTEGER");
        asnType.put(3, "BIT STRING");
        asnType.put(4, "STRING");
        asnType.put(5, "NULL");
        asnType.put(6, "OBJECT IDENTIFIER");
        asnType.put(48, "SEQUENCE");
        asnType.put(64, "IP ADDRESS");
        asnType.put(65, "COUNTER32");
        asnType.put(66, "GAUGE32");
        asnType.put(67, "TIMETICKS");
        asnType.put(68, "OPAQUE");
        asnType.put(69, "NSAP ADDRESS");
        asnType.put(70, "COUNTER64");
        asnType.put(71, "UINTEGER32");
        asnType.put(72, "FLOAT");
        asnType.put(73, "DOUBLE");
        asnType.put(74, "INTEGER64");
        asnType.put(75, "UINTEGER64");
    }

    private static String safeGetText(String[] texts, int code, String defaultValue) {
        String result;
        try {
            result = texts[code];
        }
        catch (Exception e) {
            result = defaultValue;
        }
        return result;
    }

    public static String getObjectStatusName(int status) {
        return SnmpConstants.safeGetText(mibObjectStatus, status, "Unknown");
    }

    public static String getObjectAccessName(int access) {
        return SnmpConstants.safeGetText(mibObjectAccess, access, "Unknown");
    }

    public static String getObjectTypeName(int type) {
        return SnmpConstants.safeGetText(mibObjectType, type, "Unknown");
    }

    public static String getAsnTypeName(int type) {
        String name = asnType.get(type);
        if (name == null) {
            name = "0x" + Integer.toHexString(type);
        }
        return name;
    }
}

