/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.snmp.dialogs.pages;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.netxms.client.snmp.SnmpObjectId;
import org.netxms.client.snmp.SnmpTrap;
import org.netxms.client.snmp.SnmpTrapParameterMapping;
import org.netxms.ui.eclipse.snmp.Activator;
import org.netxms.ui.eclipse.snmp.Messages;
import org.netxms.ui.eclipse.snmp.dialogs.ParamMappingEditDialog;
import org.netxms.ui.eclipse.snmp.dialogs.helpers.ParamMappingLabelProvider;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class SnmpTrapParameters
extends PreferencePage {
    private static final String PARAMLIST_TABLE_SETTINGS = "TrapConfigurationDialog.ParamList";
    private SnmpTrap trap;
    private List<SnmpTrapParameterMapping> pmap;
    private TableViewer paramList;
    private Button buttonAdd;
    private Button buttonEdit;
    private Button buttonDelete;
    private Button buttonUp;
    private Button buttonDown;

    public SnmpTrapParameters(SnmpTrap trap) {
        super("Parameters");
        this.noDefaultAndApplyButton();
        this.trap = trap;
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 4;
        layout.horizontalSpacing = 4;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.paramList = new TableViewer(dialogArea, 67584);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.widthHint = 300;
        this.paramList.getTable().setLayoutData((Object)gd);
        this.setupParameterList();
        Composite buttonArea = new Composite(dialogArea, 0);
        RowLayout btnLayout = new RowLayout();
        btnLayout.type = 512;
        btnLayout.marginBottom = 0;
        btnLayout.marginLeft = 0;
        btnLayout.marginRight = 0;
        btnLayout.marginTop = 0;
        btnLayout.fill = true;
        btnLayout.spacing = 4;
        buttonArea.setLayout((Layout)btnLayout);
        gd = new GridData();
        gd.verticalAlignment = 128;
        buttonArea.setLayoutData((Object)gd);
        this.buttonAdd = new Button(buttonArea, 8);
        Messages.get();
        this.buttonAdd.setText(Messages.TrapConfigurationDialog_Add);
        this.buttonAdd.setLayoutData((Object)new RowData(90, -1));
        this.buttonAdd.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SnmpTrapParameters.this.addParameter();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.buttonEdit = new Button(buttonArea, 8);
        Messages.get();
        this.buttonEdit.setText(Messages.TrapConfigurationDialog_Edit);
        this.buttonEdit.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SnmpTrapParameters.this.editParameter();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.buttonEdit.setEnabled(false);
        this.buttonDelete = new Button(buttonArea, 8);
        Messages.get();
        this.buttonDelete.setText(Messages.TrapConfigurationDialog_Delete);
        this.buttonDelete.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                SnmpTrapParameters.this.deleteParameters();
            }
        });
        this.buttonDelete.setEnabled(false);
        this.buttonUp = new Button(buttonArea, 8);
        Messages.get();
        this.buttonUp.setText(Messages.TrapConfigurationDialog_MoveUp);
        this.buttonDown = new Button(buttonArea, 8);
        Messages.get();
        this.buttonDown.setText(Messages.TrapConfigurationDialog_MoveDown);
        return dialogArea;
    }

    private void addParameter() {
        SnmpTrapParameterMapping pm = new SnmpTrapParameterMapping(new SnmpObjectId());
        ParamMappingEditDialog dlg = new ParamMappingEditDialog(this.getShell(), pm);
        if (dlg.open() == 0) {
            this.pmap.add(pm);
            this.paramList.setInput((Object)this.pmap.toArray());
            this.paramList.setSelection((ISelection)new StructuredSelection((Object)pm));
        }
    }

    private void editParameter() {
        IStructuredSelection selection = (IStructuredSelection)this.paramList.getSelection();
        if (selection.size() != 1) {
            return;
        }
        SnmpTrapParameterMapping pm = (SnmpTrapParameterMapping)selection.getFirstElement();
        ParamMappingEditDialog dlg = new ParamMappingEditDialog(this.getShell(), pm);
        if (dlg.open() == 0) {
            this.paramList.update((Object)pm, null);
        }
    }

    private void deleteParameters() {
        IStructuredSelection selection = (IStructuredSelection)this.paramList.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            this.pmap.remove(it.next());
        }
        this.paramList.setInput((Object)this.pmap.toArray());
    }

    private void setupParameterList() {
        Table table = this.paramList.getTable();
        table.setHeaderVisible(true);
        TableColumn tc = new TableColumn(table, 16384);
        Messages.get();
        tc.setText(Messages.TrapConfigurationDialog_Number);
        tc.setWidth(90);
        tc = new TableColumn(table, 16384);
        Messages.get();
        tc.setText(Messages.TrapConfigurationDialog_Parameter);
        tc.setWidth(200);
        this.pmap = new ArrayList<SnmpTrapParameterMapping>(this.trap.getParameterMapping());
        this.paramList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.paramList.setLabelProvider((IBaseLabelProvider)new ParamMappingLabelProvider(this.pmap));
        this.paramList.setInput((Object)this.pmap.toArray());
        WidgetHelper.restoreColumnSettings((Table)table, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)PARAMLIST_TABLE_SETTINGS);
        this.paramList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SnmpTrapParameters.this.editParameter();
            }
        });
        this.paramList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = SnmpTrapParameters.this.paramList.getStructuredSelection();
                SnmpTrapParameters.this.buttonEdit.setEnabled(selection.size() == 1);
                SnmpTrapParameters.this.buttonDelete.setEnabled(!selection.isEmpty());
            }
        });
    }

    private void saveSettings() {
        WidgetHelper.saveColumnSettings((Table)this.paramList.getTable(), (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)PARAMLIST_TABLE_SETTINGS);
    }

    public boolean performCancel() {
        if (this.isControlCreated()) {
            this.saveSettings();
        }
        return super.performCancel();
    }

    public boolean performOk() {
        if (this.isControlCreated()) {
            this.trap.getParameterMapping().clear();
            this.trap.getParameterMapping().addAll(this.pmap);
            this.saveSettings();
        }
        return super.performOk();
    }
}

