/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.propertypages;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.dashboard.Messages;
import org.netxms.ui.eclipse.dashboard.widgets.TitleConfigurator;
import org.netxms.ui.eclipse.dashboard.widgets.internal.ObjectStatusChartConfig;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class ObjectStatusChart
extends PropertyPage {
    private ObjectStatusChartConfig config;
    private ObjectSelector objectSelector;
    private TitleConfigurator title;
    private Spinner refreshRate;
    private Button checkShowLegend;
    private Button checkTransposed;
    private Button checkTranslucent;

    protected Control createContents(Composite parent) {
        this.config = (ObjectStatusChartConfig)this.getElement().getAdapter(ObjectStatusChartConfig.class);
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.objectSelector = new ObjectSelector(dialogArea, 0, false, true);
        Messages.get();
        this.objectSelector.setLabel(Messages.ObjectStatusChart_RootObject);
        this.objectSelector.setObjectClass(AbstractObject.class);
        this.objectSelector.setObjectId(this.config.getRootObject());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.objectSelector.setLayoutData((Object)gd);
        this.title = new TitleConfigurator(dialogArea, this.config);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.title.setLayoutData(gd);
        Group optionsGroup = new Group(dialogArea, 0);
        Messages.get();
        optionsGroup.setText(Messages.ObjectStatusChart_Options);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        optionsGroup.setLayoutData((Object)gd);
        GridLayout optionsLayout = new GridLayout();
        optionsGroup.setLayout((Layout)optionsLayout);
        this.checkShowLegend = new Button((Composite)optionsGroup, 32);
        Messages.get();
        this.checkShowLegend.setText(Messages.ObjectStatusChart_ShowLegend);
        this.checkShowLegend.setSelection(this.config.isShowLegend());
        this.checkTransposed = new Button((Composite)optionsGroup, 32);
        Messages.get();
        this.checkTransposed.setText(Messages.ObjectStatusChart_Transposed);
        this.checkTransposed.setSelection(this.config.isTransposed());
        this.checkTranslucent = new Button((Composite)optionsGroup, 32);
        Messages.get();
        this.checkTranslucent.setText(Messages.ObjectStatusChart_Translucent);
        this.checkTranslucent.setSelection(this.config.isTranslucent());
        gd = new GridData();
        gd.verticalAlignment = 128;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        Messages.get();
        this.refreshRate = WidgetHelper.createLabeledSpinner((Composite)dialogArea, (int)2048, (String)Messages.ObjectStatusChart_RefreshInterval, (int)1, (int)10000, (Object)gd);
        this.refreshRate.setSelection(this.config.getRefreshRate());
        return dialogArea;
    }

    public boolean performOk() {
        this.title.updateConfiguration(this.config);
        this.config.setRootObject(this.objectSelector.getObjectId());
        this.config.setShowLegend(this.checkShowLegend.getSelection());
        this.config.setTransposed(this.checkTransposed.getSelection());
        this.config.setTranslucent(this.checkTranslucent.getSelection());
        this.config.setRefreshRate(this.refreshRate.getSelection());
        return true;
    }
}

