/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.HistoricalDataType;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.datacollection.ChartDciConfig;
import org.netxms.client.datacollection.DciData;
import org.netxms.client.datacollection.DciDataRow;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.datacollection.MeasurementUnit;
import org.netxms.client.datacollection.Threshold;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.charts.widgets.Chart;
import org.netxms.ui.eclipse.compatibility.GraphItem;
import org.netxms.ui.eclipse.dashboard.Messages;
import org.netxms.ui.eclipse.dashboard.widgets.DashboardControl;
import org.netxms.ui.eclipse.dashboard.widgets.ElementWidget;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.ViewRefreshController;

public abstract class ComparisonChartElement
extends ElementWidget {
    protected Chart chart;
    protected NXCSession session;
    protected int refreshInterval = 30;
    protected boolean updateThresholds = false;
    protected List<ChartDciConfig> runtimeDciList = new ArrayList<ChartDciConfig>();
    private ViewRefreshController refreshController;
    private boolean updateInProgress = false;

    public ComparisonChartElement(DashboardControl parent, DashboardElement element, IViewPart viewPart) {
        super(parent, element, viewPart);
        this.session = ConsoleSharedData.getSession();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ComparisonChartElement.this.refreshController != null) {
                    ComparisonChartElement.this.refreshController.dispose();
                }
            }
        });
    }

    protected void configureMetrics() {
        ConsoleJob job = new ConsoleJob("Reading measurement unit information", (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.dashboard"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                DciValue[] nodeDciList = null;
                ChartDciConfig[] chartDciConfigArray = ComparisonChartElement.this.getDciList();
                int n = chartDciConfigArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ChartDciConfig dci = chartDciConfigArray[n2];
                    if (dci.nodeId == 0L || dci.nodeId == 0xFFFFFFFFL) {
                        AbstractObject contextObject = ComparisonChartElement.this.getContext();
                        if (contextObject != null) {
                            if (nodeDciList == null) {
                                nodeDciList = ComparisonChartElement.this.session.getLastValues(contextObject.getObjectId());
                            }
                            if (dci.regexMatch) {
                                Pattern namePattern = Pattern.compile(dci.dciName);
                                Pattern descriptionPattern = Pattern.compile(dci.dciDescription);
                                DciValue[] dciValueArray = nodeDciList;
                                int n3 = nodeDciList.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    DciValue dciInfo = dciValueArray[n4];
                                    if (dciInfo.getDcObjectType() == 1) {
                                        Matcher nameMatch = namePattern.matcher(dciInfo.getName());
                                        Matcher descriptionMatch = descriptionPattern.matcher(dciInfo.getDescription());
                                        if (!dci.dciName.isEmpty() && nameMatch.find() || !dci.dciDescription.isEmpty() && descriptionMatch.find()) {
                                            ChartDciConfig instance = new ChartDciConfig(dci, !dci.dciName.isEmpty() && nameMatch.find() ? nameMatch : descriptionMatch, dciInfo);
                                            ComparisonChartElement.this.runtimeDciList.add(instance);
                                            if (!dci.multiMatch) break;
                                        }
                                    }
                                    ++n4;
                                }
                            } else {
                                DciValue[] dciValueArray = nodeDciList;
                                int n5 = nodeDciList.length;
                                int n6 = 0;
                                while (n6 < n5) {
                                    DciValue dciInfo = dciValueArray[n6];
                                    if (!dci.dciName.isEmpty() && dciInfo.getName().equalsIgnoreCase(dci.dciName) || !dci.dciDescription.isEmpty() && dciInfo.getDescription().equalsIgnoreCase(dci.dciDescription)) {
                                        ComparisonChartElement.this.runtimeDciList.add(new ChartDciConfig(dci, dciInfo));
                                        if (!dci.multiMatch) break;
                                    }
                                    ++n6;
                                }
                            }
                        }
                    } else {
                        ComparisonChartElement.this.runtimeDciList.add(dci);
                    }
                    ++n2;
                }
                final Map measurementUnits = ComparisonChartElement.this.session.getDciMeasurementUnits(ComparisonChartElement.this.runtimeDciList);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).ComparisonChartElement.this.chart.isDisposed()) {
                            return;
                        }
                        for (ChartDciConfig dci : (this).ComparisonChartElement.this.runtimeDciList) {
                            GraphItem item = new GraphItem(dci);
                            item.setMeasurementUnit((MeasurementUnit)measurementUnits.get(dci.getDciId()));
                            (this).ComparisonChartElement.this.chart.addParameter(item);
                        }
                        (this).ComparisonChartElement.this.chart.rebuild();
                        ComparisonChartElement.this.layout(true, true);
                        ComparisonChartElement.this.startRefreshTimer();
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot read measurement unit information";
            }
        };
        job.setUser(false);
        job.start();
    }

    protected void startRefreshTimer() {
        this.refreshController = new ViewRefreshController(this.viewPart, this.refreshInterval, new Runnable(){

            @Override
            public void run() {
                if (ComparisonChartElement.this.isDisposed()) {
                    return;
                }
                ComparisonChartElement.this.refreshData();
            }
        });
        this.refreshData();
    }

    protected void refreshData() {
        if (this.updateInProgress) {
            return;
        }
        this.updateInProgress = true;
        Messages.get();
        ConsoleJob job = new ConsoleJob(Messages.ComparisonChartElement_JobTitle, (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.dashboard"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                Threshold[][] thresholds;
                final DciData[] data = new DciData[ComparisonChartElement.this.runtimeDciList.size()];
                int i = 0;
                while (i < ComparisonChartElement.this.runtimeDciList.size()) {
                    ChartDciConfig dci = ComparisonChartElement.this.runtimeDciList.get(i);
                    data[i] = dci.type == 1 ? ComparisonChartElement.this.session.getCollectedData(dci.nodeId, dci.dciId, null, null, 1, HistoricalDataType.PROCESSED) : ComparisonChartElement.this.session.getCollectedTableData(dci.nodeId, dci.dciId, dci.instance, dci.column, null, null, 1);
                    ++i;
                }
                if (ComparisonChartElement.this.updateThresholds) {
                    thresholds = new Threshold[ComparisonChartElement.this.runtimeDciList.size()][];
                    int i2 = 0;
                    while (i2 < ComparisonChartElement.this.runtimeDciList.size()) {
                        ChartDciConfig dci = ComparisonChartElement.this.runtimeDciList.get(i2);
                        thresholds[i2] = dci.type == 1 ? ComparisonChartElement.this.session.getThresholds(dci.nodeId, dci.dciId) : new Threshold[0];
                        ++i2;
                    }
                } else {
                    thresholds = null;
                }
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).ComparisonChartElement.this.updateInProgress = false;
                        if ((this).ComparisonChartElement.this.chart.isDisposed()) {
                            return;
                        }
                        int i = 0;
                        while (i < data.length) {
                            DciDataRow lastValue = data[i].getLastValue();
                            (this).ComparisonChartElement.this.chart.updateParameter(i, lastValue != null ? lastValue : new DciDataRow(new Date(), (Object)0.0), data[i].getDataType(), false);
                            if ((this).ComparisonChartElement.this.updateThresholds) {
                                (this).ComparisonChartElement.this.chart.updateParameterThresholds(i, thresholds[i]);
                            }
                            ++i;
                        }
                        (this).ComparisonChartElement.this.chart.refresh();
                        (this).ComparisonChartElement.this.chart.clearErrors();
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.ComparisonChartElement_JobError;
            }

            protected void jobFailureHandler() {
                ComparisonChartElement.this.updateInProgress = false;
                super.jobFailureHandler();
            }

            protected IStatus createFailureStatus(final Exception e) {
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).ComparisonChartElement.this.chart.addError(String.valueOf(this.getErrorMessage()) + " (" + e.getLocalizedMessage() + ")");
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.start();
    }

    protected abstract ChartDciConfig[] getDciList();
}

