/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewPart;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.ui.eclipse.dashboard.widgets.DashboardControl;
import org.netxms.ui.eclipse.dashboard.widgets.ElementWidget;
import org.netxms.ui.eclipse.dashboard.widgets.internal.LabelConfig;
import org.netxms.ui.eclipse.tools.ColorConverter;
import org.netxms.ui.eclipse.tools.FontTools;

public class LabelElement
extends ElementWidget {
    private LabelConfig config;
    private Label label;
    private Font font;

    public LabelElement(DashboardControl parent, DashboardElement element, IViewPart viewPart) {
        super(parent, element, viewPart);
        try {
            this.config = LabelConfig.createFromXmlOrJson(element.getData());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.config = new LabelConfig();
        }
        FillLayout layout = new FillLayout();
        layout.marginHeight = 4;
        this.getContentArea().setLayout((Layout)layout);
        this.label = new Label(this.getContentArea(), 0x1000000);
        this.label.setText(this.config.getTitle());
        this.label.setBackground(this.colors.create(ColorConverter.parseColorDefinition((String)this.config.getTitleBackground())));
        this.label.setForeground(this.colors.create(ColorConverter.parseColorDefinition((String)this.config.getTitleForeground())));
        this.getContentArea().setBackground(this.label.getBackground());
        this.font = FontTools.createAdjustedFont((Font)FontTools.getTitleFont(), (int)this.config.getTitleFontSize());
        this.label.setFont(this.font);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                LabelElement.this.font.dispose();
            }
        });
    }

    @Override
    protected int getPreferredHeight() {
        return 16;
    }
}

