/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets;

import com.google.gson.Gson;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.ui.IViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.RackOrientation;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.objects.Rack;
import org.netxms.ui.eclipse.console.resources.ThemeEngine;
import org.netxms.ui.eclipse.dashboard.widgets.DashboardControl;
import org.netxms.ui.eclipse.dashboard.widgets.ElementWidget;
import org.netxms.ui.eclipse.dashboard.widgets.internal.RackDiagramConfig;
import org.netxms.ui.eclipse.dashboard.widgets.internal.RackDisplayMode;
import org.netxms.ui.eclipse.objectbrowser.api.ObjectContextMenu;
import org.netxms.ui.eclipse.objectview.widgets.RackWidget;
import org.netxms.ui.eclipse.objectview.widgets.helpers.ElementSelectionListener;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class RackDiagramElement
extends ElementWidget
implements ISelectionProvider {
    private RackWidget rackFrontWidget = null;
    private RackWidget rackRearWidget = null;
    private NXCSession session;
    private RackDiagramConfig config;
    private Composite rackArea;
    private ScrolledComposite scroller;
    private Font font = null;
    private IViewPart viewPart;
    private ISelection selection = new StructuredSelection();
    private Set<ISelectionChangedListener> selectionListeners = new HashSet<ISelectionChangedListener>();

    protected RackDiagramElement(DashboardControl parent, DashboardElement element, IViewPart viewPart) {
        super(parent, element, viewPart);
        this.viewPart = viewPart;
        try {
            this.config = (RackDiagramConfig)new Gson().fromJson(element.getData(), RackDiagramConfig.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.config = new RackDiagramConfig();
        }
        this.processCommonSettings(this.config);
        this.session = ConsoleSharedData.getSession();
        Rack rack = (Rack)this.session.findObjectById(this.getEffectiveObjectId(this.config.getObjectId()), Rack.class);
        if (rack != null) {
            Color backgroundColor = ThemeEngine.getBackgroundColor((String)"Rack");
            this.scroller = new ScrolledComposite(this.getContentArea(), 768);
            this.rackArea = new Composite((Composite)this.scroller, 0){

                public Point computeSize(int wHint, int hHint, boolean changed) {
                    if (RackDiagramElement.this.rackFrontWidget != null && RackDiagramElement.this.rackRearWidget != null) {
                        Point s = RackDiagramElement.this.rackFrontWidget.computeSize(wHint != -1 ? wHint / 2 : wHint, hHint, changed);
                        return new Point(s.x * 2, s.y);
                    }
                    if (RackDiagramElement.this.rackFrontWidget != null) {
                        Point s = RackDiagramElement.this.rackFrontWidget.computeSize(wHint, hHint, changed);
                        return new Point(s.x, s.y);
                    }
                    if (RackDiagramElement.this.rackRearWidget != null) {
                        Point s = RackDiagramElement.this.rackRearWidget.computeSize(wHint, hHint, changed);
                        return new Point(s.x, s.y);
                    }
                    return super.computeSize(wHint, hHint, changed);
                }
            };
            this.rackArea.setBackground(backgroundColor);
            this.rackArea.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    Point rackAreaSize = RackDiagramElement.this.rackArea.getSize();
                    if (RackDiagramElement.this.rackFrontWidget != null && RackDiagramElement.this.rackRearWidget != null) {
                        Point size = RackDiagramElement.this.rackFrontWidget.computeSize(rackAreaSize.x / 2, rackAreaSize.y, true);
                        RackDiagramElement.this.rackFrontWidget.setSize(size);
                        RackDiagramElement.this.rackRearWidget.setSize(size);
                        RackDiagramElement.this.rackRearWidget.setLocation(size.x, 0);
                    } else if (RackDiagramElement.this.rackFrontWidget != null) {
                        Point size = RackDiagramElement.this.rackFrontWidget.computeSize(rackAreaSize.x, rackAreaSize.y, true);
                        RackDiagramElement.this.rackFrontWidget.setSize(size);
                    } else if (RackDiagramElement.this.rackRearWidget != null) {
                        Point size = RackDiagramElement.this.rackRearWidget.computeSize(rackAreaSize.x, rackAreaSize.y, true);
                        RackDiagramElement.this.rackRearWidget.setSize(size);
                    }
                }
            });
            if (this.config.getDisplayMode() == RackDisplayMode.FULL || this.config.getDisplayMode() == RackDisplayMode.FRONT) {
                this.setRackFrontWidget(new RackWidget(this.rackArea, 0, rack, RackOrientation.FRONT));
            }
            if (this.config.getDisplayMode() == RackDisplayMode.FULL && !rack.isFrontSideOnly() || this.config.getDisplayMode() == RackDisplayMode.BACK) {
                this.setRackRearWidget(new RackWidget(this.rackArea, 0, rack, RackOrientation.REAR));
            }
            this.scroller.setContent((Control)this.rackArea);
            this.scroller.setExpandHorizontal(true);
            this.scroller.setExpandVertical(true);
            WidgetHelper.setScrollBarIncrement((Scrollable)this.scroller, (int)256, (int)20);
            WidgetHelper.setScrollBarIncrement((Scrollable)this.scroller, (int)512, (int)20);
            this.scroller.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    Point scrollerSize = RackDiagramElement.this.scroller.getSize();
                    RackDiagramElement.this.scroller.setMinSize(RackDiagramElement.this.rackArea.computeSize(scrollerSize.x, scrollerSize.y));
                }
            });
        }
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (RackDiagramElement.this.font != null) {
                    RackDiagramElement.this.font.dispose();
                }
            }
        });
        ElementSelectionListener listener = new ElementSelectionListener(){

            public void objectSelected(Object object) {
                RackDiagramElement.this.selection = object != null ? new StructuredSelection(object) : new StructuredSelection();
                for (ISelectionChangedListener listener : RackDiagramElement.this.selectionListeners) {
                    listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)RackDiagramElement.this, RackDiagramElement.this.selection));
                }
            }
        };
        if (this.rackFrontWidget != null) {
            this.rackFrontWidget.addSelectionListener(listener);
        }
        if (this.rackRearWidget != null) {
            this.rackRearWidget.addSelectionListener(listener);
        }
        this.createPopupMenu();
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                RackDiagramElement.this.fillContextMenu(mgr);
            }
        });
        if (this.rackFrontWidget != null) {
            this.rackFrontWidget.setMenu(menuMgr.createContextMenu((Control)this.rackFrontWidget));
        }
        if (this.rackRearWidget != null) {
            this.rackRearWidget.setMenu(menuMgr.createContextMenu((Control)this.rackRearWidget));
        }
        this.viewPart.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this);
    }

    private void fillContextMenu(IMenuManager manager) {
        ObjectContextMenu.fill((IMenuManager)manager, (IShellProvider)this.viewPart.getSite(), (ISelectionProvider)this);
    }

    public RackWidget getRackRearWidget() {
        return this.rackRearWidget;
    }

    public void setRackRearWidget(RackWidget rackRearWidget) {
        this.rackRearWidget = rackRearWidget;
    }

    public RackWidget getRackFrontWidget() {
        return this.rackFrontWidget;
    }

    public void setRackFrontWidget(RackWidget rackFrontWidget) {
        this.rackFrontWidget = rackFrontWidget;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add(listener);
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
    }
}

