/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets;

import com.google.gson.Gson;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.IViewPart;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.ui.eclipse.dashboard.widgets.DashboardControl;
import org.netxms.ui.eclipse.dashboard.widgets.ElementWidget;
import org.netxms.ui.eclipse.dashboard.widgets.internal.SeparatorConfig;
import org.netxms.ui.eclipse.tools.ColorConverter;

public class SeparatorElement
extends ElementWidget {
    private SeparatorConfig config;
    private Color bkColor;
    private Color fgColor;

    public SeparatorElement(DashboardControl parent, DashboardElement element, IViewPart viewPart) {
        super(parent, 0, element, viewPart);
        try {
            this.config = (SeparatorConfig)new Gson().fromJson(element.getData(), SeparatorConfig.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.config = new SeparatorConfig();
        }
        this.getContentArea().dispose();
        this.bkColor = new Color((Device)this.getDisplay(), ColorConverter.rgbFromInt((int)this.config.getBackgroundColorAsInt()));
        this.fgColor = new Color((Device)this.getDisplay(), ColorConverter.rgbFromInt((int)this.config.getForegroundColorAsInt()));
        this.setBackground(this.bkColor);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SeparatorElement.this.bkColor.dispose();
                SeparatorElement.this.fgColor.dispose();
            }
        });
    }

    public void paintControl(PaintEvent e) {
        super.paintControl(e);
        if (this.config.getLineWidth() > 0) {
            e.gc.setForeground(this.fgColor);
            Rectangle rect = this.getClientArea();
            e.gc.setLineWidth(this.config.getLineWidth());
            int x1 = this.config.getLeftMargin();
            int x2 = rect.width - this.config.getRightMargin() - 1;
            int y = this.config.getTopMargin() + this.config.getLineWidth() / 2;
            e.gc.drawLine(x1, y, x2, y);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return new Point(wHint == -1 ? this.config.getLeftMargin() + this.config.getRightMargin() : wHint, this.config.getTopMargin() + this.config.getBottomMargin() + this.config.getLineWidth());
    }
}

