/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets;

import com.google.gson.Gson;
import org.eclipse.ui.IViewPart;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.ui.eclipse.console.Activator;
import org.netxms.ui.eclipse.dashboard.widgets.DashboardControl;
import org.netxms.ui.eclipse.dashboard.widgets.ElementWidget;
import org.netxms.ui.eclipse.dashboard.widgets.internal.StatusMapConfig;
import org.netxms.ui.eclipse.objectview.widgets.AbstractObjectStatusMap;
import org.netxms.ui.eclipse.objectview.widgets.FlatObjectStatusMap;
import org.netxms.ui.eclipse.objectview.widgets.RadialObjectStatusMap;

public class StatusMapElement
extends ElementWidget {
    private AbstractObjectStatusMap map;
    private StatusMapConfig config;

    public StatusMapElement(DashboardControl parent, DashboardElement element, IViewPart viewPart) {
        super(parent, element, viewPart);
        try {
            this.config = (StatusMapConfig)new Gson().fromJson(element.getData(), StatusMapConfig.class);
        }
        catch (Exception e) {
            Activator.logError((String)"Cannot parse dashboard element configuration", (Throwable)e);
            this.config = new StatusMapConfig();
        }
        this.processCommonSettings(this.config);
        this.map = this.config.isShowRadial() ? new RadialObjectStatusMap(viewPart, this.getContentArea(), 0, false) : new FlatObjectStatusMap(viewPart, this.getContentArea(), 0, false);
        this.map.setFitToScreen(this.config.isFitToScreen());
        if (!this.config.isShowRadial()) {
            ((FlatObjectStatusMap)this.map).setGroupObjects(this.config.isGroupObjects());
        }
        this.map.setHideObjectsInMaintenance(this.config.isHideObjectsInMaintenance());
        this.map.setSeverityFilter(this.config.getSeverityFilter());
        this.map.enableFilter(this.config.isShowTextFilter());
        this.map.setRootObject(this.getEffectiveObjectId(this.config.getObjectId()));
        this.map.addRefreshListener(new Runnable(){

            @Override
            public void run() {
                StatusMapElement.this.requestDashboardLayout();
            }
        });
    }
}

