/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.dialogs;

import java.util.HashSet;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.netxms.client.NXCSession;
import org.netxms.client.PhysicalLink;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Interface;
import org.netxms.client.objects.Rack;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.objectview.widgets.PatchPanelSelector;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class PhysicalLinkEditDialog
extends Dialog {
    private static final String[] SIDE = new String[]{"FRONT", "BACK"};
    private PhysicalLink link;
    private String title;
    private NXCSession session;
    private LabeledText description;
    private ObjectSelector objectSelectorRight;
    private PatchPanelSelector patchPanelSelectorRight;
    private Spinner portRight;
    private Combo sideRight;
    private ObjectSelector objectSelectorLeft;
    private PatchPanelSelector patchPanelSelectorLeft;
    private Spinner portLeft;
    private Combo sideLeft;
    private long currLeftObjId;
    private long currRightObjId;

    public PhysicalLinkEditDialog(Shell parentShell, PhysicalLink link) {
        super(parentShell);
        this.link = link != null ? new PhysicalLink(link) : new PhysicalLink();
        this.title = link != null ? "Edit physical link" : "Create physical link";
        this.session = ConsoleSharedData.getSession();
    }

    protected Control createDialogArea(Composite parent) {
        this.currLeftObjId = this.link.getLeftObjectId();
        this.currRightObjId = this.link.getRightObjectId();
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 2;
        this.description = new LabeledText(dialogArea, 0);
        this.description.setLabel("Description");
        this.description.setText(this.link.getDescription());
        this.description.setLayoutData((Object)gd);
        Group leftGroup = new Group(dialogArea, 0);
        layout = new GridLayout();
        layout.horizontalSpacing = 5;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        leftGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        leftGroup.setLayoutData((Object)gd);
        HashSet<Class> filterSet = new HashSet<Class>();
        this.objectSelectorLeft = new ObjectSelector((Composite)leftGroup, 0, false);
        this.objectSelectorLeft.setObjectId(this.link.getLeftObjectId());
        this.objectSelectorLeft.setLabel("Interface or rack");
        this.objectSelectorLeft.setObjectClass(filterSet);
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.objectSelectorLeft.setLayoutData((Object)gd);
        this.objectSelectorLeft.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (PhysicalLinkEditDialog.this.currLeftObjId != PhysicalLinkEditDialog.this.objectSelectorLeft.getObjectId()) {
                    PhysicalLinkEditDialog.this.patchPanelSelectorLeft.setPatchPanelId(0L);
                }
                PhysicalLinkEditDialog.this.currLeftObjId = PhysicalLinkEditDialog.this.objectSelectorLeft.getObjectId();
                if (PhysicalLinkEditDialog.this.objectSelectorLeft.getObject() instanceof Rack) {
                    PhysicalLinkEditDialog.this.patchPanelSelectorLeft.setEnabled(true);
                    PhysicalLinkEditDialog.this.portLeft.setEnabled(true);
                    PhysicalLinkEditDialog.this.sideLeft.setEnabled(true);
                    PhysicalLinkEditDialog.this.patchPanelSelectorLeft.setRack((Rack)PhysicalLinkEditDialog.this.objectSelectorLeft.getObject());
                } else {
                    PhysicalLinkEditDialog.this.patchPanelSelectorLeft.setEnabled(false);
                    PhysicalLinkEditDialog.this.portLeft.setEnabled(false);
                    PhysicalLinkEditDialog.this.sideLeft.setEnabled(false);
                }
            }
        });
        AbstractObject obj = this.session.findObjectById(this.link.getLeftObjectId());
        this.patchPanelSelectorLeft = new PatchPanelSelector((Composite)leftGroup, 0, obj instanceof Rack ? (Rack)obj : null);
        this.patchPanelSelectorLeft.setPatchPanelId(this.link.getLeftPatchPanelId());
        this.patchPanelSelectorLeft.setLabel("Patch panel");
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.patchPanelSelectorLeft.setLayoutData(gd);
        this.portLeft = WidgetHelper.createLabeledSpinner((Composite)leftGroup, (int)2048, (String)"Port", (int)1, (int)64, (Object)"WidgetHelper::default_layout_data");
        this.portLeft.setSelection(this.link.getLeftPortNumber());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.portLeft.setLayoutData((Object)gd);
        this.sideLeft = WidgetHelper.createLabeledCombo((Composite)leftGroup, (int)8, (String)"Side", (Object)gd);
        this.sideLeft.setItems(SIDE);
        this.sideLeft.select(this.link.getLeftFront());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.sideLeft.setLayoutData((Object)gd);
        if (!(obj instanceof Rack)) {
            this.patchPanelSelectorLeft.setEnabled(false);
            this.portLeft.setEnabled(false);
            this.sideLeft.setEnabled(false);
        } else {
            this.patchPanelSelectorLeft.setPatchPanelId(this.link.getLeftPatchPanelId());
        }
        Group rightGroup = new Group(dialogArea, 0);
        layout = new GridLayout();
        layout.horizontalSpacing = 5;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        rightGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        rightGroup.setLayoutData((Object)gd);
        filterSet.add(Interface.class);
        filterSet.add(Rack.class);
        this.objectSelectorRight = new ObjectSelector((Composite)rightGroup, 0, false);
        this.objectSelectorRight.setObjectId(this.link.getRightObjectId());
        this.objectSelectorRight.setLabel("Interface or rack");
        this.objectSelectorRight.setObjectClass(filterSet);
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.objectSelectorRight.setLayoutData((Object)gd);
        this.objectSelectorRight.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (PhysicalLinkEditDialog.this.currRightObjId != PhysicalLinkEditDialog.this.objectSelectorRight.getObjectId()) {
                    PhysicalLinkEditDialog.this.patchPanelSelectorRight.setPatchPanelId(0L);
                }
                PhysicalLinkEditDialog.this.currRightObjId = PhysicalLinkEditDialog.this.objectSelectorRight.getObjectId();
                if (PhysicalLinkEditDialog.this.objectSelectorRight.getObject() instanceof Rack) {
                    PhysicalLinkEditDialog.this.patchPanelSelectorRight.setEnabled(true);
                    PhysicalLinkEditDialog.this.portRight.setEnabled(true);
                    PhysicalLinkEditDialog.this.sideRight.setEnabled(true);
                    PhysicalLinkEditDialog.this.patchPanelSelectorRight.setRack((Rack)PhysicalLinkEditDialog.this.objectSelectorRight.getObject());
                } else {
                    PhysicalLinkEditDialog.this.patchPanelSelectorRight.setEnabled(false);
                    PhysicalLinkEditDialog.this.portRight.setEnabled(false);
                    PhysicalLinkEditDialog.this.sideRight.setEnabled(false);
                }
            }
        });
        obj = this.session.findObjectById(this.link.getRightObjectId());
        this.patchPanelSelectorRight = new PatchPanelSelector((Composite)rightGroup, 0, obj instanceof Rack ? (Rack)obj : null);
        this.patchPanelSelectorRight.setLabel("Patch panel");
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.patchPanelSelectorRight.setLayoutData(gd);
        this.portRight = WidgetHelper.createLabeledSpinner((Composite)rightGroup, (int)2048, (String)"Port", (int)1, (int)64, (Object)"WidgetHelper::default_layout_data");
        this.portRight.setSelection(this.link.getRightPortNumber());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.portRight.setLayoutData((Object)gd);
        this.sideRight = WidgetHelper.createLabeledCombo((Composite)rightGroup, (int)8, (String)"Side", (Object)gd);
        this.sideRight.setItems(SIDE);
        this.sideRight.select(this.link.getRightFront());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.sideRight.setLayoutData((Object)gd);
        if (!(obj instanceof Rack)) {
            this.patchPanelSelectorRight.setEnabled(false);
            this.portRight.setEnabled(false);
            this.sideRight.setEnabled(false);
        } else {
            this.patchPanelSelectorRight.setPatchPanelId(this.link.getRightPatchPanelId());
        }
        return dialogArea;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    protected void okPressed() {
        if (this.objectSelectorLeft.getObject() == null || this.objectSelectorRight.getObject() == null) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Please select objects for both sides of the link");
            return;
        }
        if (this.objectSelectorLeft.getObject() instanceof Rack && this.patchPanelSelectorLeft.getPatchPanelId() == 0L || this.objectSelectorRight.getObject() instanceof Rack && this.patchPanelSelectorRight.getPatchPanelId() == 0L) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Please select patch panel(s) for rack(s)");
            return;
        }
        this.link.setDescription(this.description.getText());
        this.link.setLeftObjectId(this.objectSelectorLeft.getObjectId());
        if (this.objectSelectorLeft.getObject() instanceof Rack) {
            this.link.setLeftPatchPanelId(this.patchPanelSelectorLeft.getPatchPanelId());
            this.link.setLeftPortNumber(this.portLeft.getSelection());
            this.link.setLeftFront(this.sideLeft.getSelectionIndex() == 0);
        }
        this.link.setRightObjectId(this.objectSelectorRight.getObjectId());
        if (this.objectSelectorRight.getObject() instanceof Rack) {
            this.link.setRightPatchPanelId(this.patchPanelSelectorRight.getPatchPanelId());
            this.link.setRightPortNumber(this.portRight.getSelection());
            this.link.setRightFront(this.sideRight.getSelectionIndex() == 0);
        }
        super.okPressed();
    }

    public PhysicalLink getLink() {
        return this.link;
    }
}

