/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectview.Messages;
import org.netxms.ui.eclipse.objectview.widgets.helpers.SoftwareInventoryContentProvider;
import org.netxms.ui.eclipse.objectview.widgets.helpers.SoftwareInventoryNode;
import org.netxms.ui.eclipse.objectview.widgets.helpers.SoftwarePackageComparator;
import org.netxms.ui.eclipse.objectview.widgets.helpers.SoftwarePackageLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;
import org.netxms.ui.eclipse.widgets.SortableTreeViewer;

public class SoftwareInventory
extends Composite {
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_VERSION = 1;
    public static final int COLUMN_VENDOR = 2;
    public static final int COLUMN_DATE = 3;
    public static final int COLUMN_DESCRIPTION = 4;
    public static final int COLUMN_URL = 5;
    private static final String[] names;
    private static final int[] widths;
    private IViewPart viewPart;
    private long rootObjectId;
    private ColumnViewer viewer;
    private MenuManager menuManager = null;

    static {
        String[] stringArray = new String[6];
        Messages.get();
        stringArray[0] = Messages.SoftwareInventory_Name;
        Messages.get();
        stringArray[1] = Messages.SoftwareInventory_Version;
        Messages.get();
        stringArray[2] = Messages.SoftwareInventory_Vendor;
        Messages.get();
        stringArray[3] = Messages.SoftwareInventory_InstallDate;
        Messages.get();
        stringArray[4] = Messages.SoftwareInventory_Description;
        Messages.get();
        stringArray[5] = Messages.SoftwareInventory_URL;
        names = stringArray;
        widths = new int[]{200, 100, 200, 100, 300, 200};
    }

    public SoftwareInventory(Composite parent, int style, IViewPart viewPart) {
        super(parent, style);
        this.viewPart = viewPart;
        this.setLayout((Layout)new FillLayout());
        this.createTableViewer();
    }

    private void createTableViewer() {
        this.viewer = new SortableTableViewer((Composite)this, names, widths, 0, 128, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new SoftwarePackageLabelProvider(false));
        this.viewer.setComparator((ViewerComparator)new SoftwarePackageComparator());
        if (this.menuManager != null) {
            Menu menu = this.menuManager.createContextMenu(this.viewer.getControl());
            this.viewer.getControl().setMenu(menu);
            this.viewPart.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
            this.viewPart.getSite().registerContextMenu(this.menuManager, (ISelectionProvider)this.viewer);
        }
    }

    private void createTreeViewer() {
        this.viewer = new SortableTreeViewer((Composite)this, names, widths, 0, 128, 65538);
        this.viewer.setContentProvider((IContentProvider)new SoftwareInventoryContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new SoftwarePackageLabelProvider(true));
        this.viewer.setComparator((ViewerComparator)new SoftwarePackageComparator());
        if (this.menuManager != null) {
            Menu menu = this.menuManager.createContextMenu(this.viewer.getControl());
            this.viewer.getControl().setMenu(menu);
            this.viewPart.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
            this.viewPart.getSite().registerContextMenu(this.menuManager, (ISelectionProvider)this.viewer);
        }
    }

    public void refresh() {
        final NXCSession session = ConsoleSharedData.getSession();
        Messages.get();
        new ConsoleJob(Messages.SoftwareInventory_JobName, (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.objectview"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                AbstractObject object = session.findObjectById(SoftwareInventory.this.rootObjectId);
                if (object instanceof AbstractNode) {
                    final List packages = session.getNodeSoftwarePackages(SoftwareInventory.this.rootObjectId);
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            (this).SoftwareInventory.this.viewer.setInput((Object)packages.toArray());
                            ((SortableTableViewer)(this).SoftwareInventory.this.viewer).packColumns();
                        }
                    });
                } else {
                    final ArrayList<SoftwareInventoryNode> nodes = new ArrayList<SoftwareInventoryNode>();
                    for (AbstractObject o : object.getAllChildren(2)) {
                        try {
                            List packages = session.getNodeSoftwarePackages(o.getObjectId());
                            nodes.add(new SoftwareInventoryNode((Node)o, packages));
                        }
                        catch (NXCException e) {
                            if (e.getErrorCode() == 100) continue;
                            throw e;
                        }
                    }
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            (this).SoftwareInventory.this.viewer.setInput((Object)nodes);
                            ((SortableTreeViewer)(this).SoftwareInventory.this.viewer).packColumns();
                        }
                    });
                }
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.SoftwareInventory_JobError;
            }
        }.start();
    }

    public long getRootObjectId() {
        return this.rootObjectId;
    }

    public void setRootObjectId(long rootObjectId) {
        this.rootObjectId = rootObjectId;
        AbstractObject object = ConsoleSharedData.getSession().findObjectById(rootObjectId);
        if (object instanceof Node) {
            if (!(this.viewer instanceof SortableTableViewer)) {
                this.viewer.getControl().dispose();
                this.createTableViewer();
            }
        } else if (!(this.viewer instanceof SortableTreeViewer)) {
            this.viewer.getControl().dispose();
            this.createTreeViewer();
        }
    }

    public ColumnViewer getViewer() {
        return this.viewer;
    }

    public void setViewerMenu(MenuManager manager) {
        this.menuManager = manager;
        if (this.viewer != null) {
            Menu menu = this.menuManager.createContextMenu(this.viewer.getControl());
            this.viewer.getControl().setMenu(menu);
            this.viewPart.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
            this.viewPart.getSite().registerContextMenu(this.menuManager, (ISelectionProvider)this.viewer);
        }
    }
}

