/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.widgets.helpers;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.client.SoftwarePackage;
import org.netxms.ui.eclipse.console.resources.RegionalSettings;
import org.netxms.ui.eclipse.objectview.Activator;
import org.netxms.ui.eclipse.objectview.widgets.helpers.SoftwareInventoryNode;

public class SoftwarePackageLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private WorkbenchLabelProvider wbl = new WorkbenchLabelProvider();
    private Image imgPackage = Activator.getImageDescriptor("icons/package.gif").createImage();
    private boolean treeMode;

    public SoftwarePackageLabelProvider(boolean treeMode) {
        this.treeMode = treeMode;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            if (element instanceof SoftwareInventoryNode) {
                return this.wbl.getImage((Object)((SoftwareInventoryNode)element).getNode());
            }
            if (this.treeMode && element instanceof SoftwarePackage) {
                return this.imgPackage;
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof SoftwareInventoryNode) {
            if (columnIndex == 0) {
                return ((SoftwareInventoryNode)element).getNode().getObjectName();
            }
        } else {
            SoftwarePackage p = (SoftwarePackage)element;
            switch (columnIndex) {
                case 3: {
                    if (p.getInstallDate() == null || p.getInstallDate().getTime() == 0L) {
                        return null;
                    }
                    return RegionalSettings.getDateFormat().format(p.getInstallDate());
                }
                case 4: {
                    return p.getDescription();
                }
                case 0: {
                    return p.getName();
                }
                case 5: {
                    return p.getSupportUrl();
                }
                case 2: {
                    return p.getVendor();
                }
                case 1: {
                    return p.getVersion();
                }
            }
        }
        return null;
    }

    public void dispose() {
        this.wbl.dispose();
        this.imgPackage.dispose();
        super.dispose();
    }
}

