/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.ui.eclipse.objectmanager.Activator;
import org.netxms.ui.eclipse.objectmanager.Messages;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class CreateNetworkServiceDialog
extends Dialog {
    private LabeledText nameField;
    private LabeledText aliasField;
    private Combo serviceTypeField;
    private LabeledText portField;
    private LabeledText requestField;
    private LabeledText responseField;
    private Button checkCreateDci;
    private String name;
    private String alias;
    private int serviceType;
    private int port;
    private String request;
    private String response;
    private boolean createDci;

    public CreateNetworkServiceDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        Messages.get();
        newShell.setText(Messages.CreateNetworkServiceDialog_Title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.nameField = new LabeledText(dialogArea, 0);
        Messages.get();
        this.nameField.setLabel(Messages.CreateNetworkServiceDialog_Name);
        this.nameField.getTextControl().setTextLimit(255);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 300;
        gd.horizontalSpan = 2;
        this.nameField.setLayoutData((Object)gd);
        this.aliasField = new LabeledText(dialogArea, 0);
        Messages.get();
        this.aliasField.setLabel(Messages.CreateNetworkServiceDialog_Alias);
        this.aliasField.getTextControl().setTextLimit(255);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.aliasField.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        Messages.get();
        this.serviceTypeField = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)Messages.CreateNetworkServiceDialog_ServiceType, (Object)gd);
        Messages.get();
        this.serviceTypeField.add(Messages.CreateNetworkServiceDialog_TypeUserDef);
        Messages.get();
        this.serviceTypeField.add(Messages.CreateNetworkServiceDialog_TypeSSH);
        Messages.get();
        this.serviceTypeField.add(Messages.CreateNetworkServiceDialog_TypePOP3);
        Messages.get();
        this.serviceTypeField.add(Messages.CreateNetworkServiceDialog_TypeSMTP);
        Messages.get();
        this.serviceTypeField.add(Messages.CreateNetworkServiceDialog_TypeFTP);
        Messages.get();
        this.serviceTypeField.add(Messages.CreateNetworkServiceDialog_TypeHTTP);
        Messages.get();
        this.serviceTypeField.add(Messages.CreateNetworkServiceDialog_TypeHTTPS);
        Messages.get();
        this.serviceTypeField.add(Messages.CreateNetworkServiceDialog_TypeTelnet);
        this.serviceTypeField.select(0);
        this.portField = new LabeledText(dialogArea, 0);
        Messages.get();
        this.portField.setLabel(Messages.CreateNetworkServiceDialog_Port);
        this.portField.setText("0");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.portField.setLayoutData((Object)gd);
        this.requestField = new LabeledText(dialogArea, 0);
        Messages.get();
        this.requestField.setLabel(Messages.CreateNetworkServiceDialog_Request);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.requestField.setLayoutData((Object)gd);
        this.responseField = new LabeledText(dialogArea, 0);
        Messages.get();
        this.responseField.setLabel(Messages.CreateNetworkServiceDialog_Response);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.responseField.setLayoutData((Object)gd);
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        this.checkCreateDci = new Button(dialogArea, 32);
        Messages.get();
        this.checkCreateDci.setText(Messages.CreateNetworkServiceDialog_CreateStatusDCI);
        this.checkCreateDci.setSelection(settings.getBoolean("CreateNetworkServiceDialog.checkCreateDci"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.checkCreateDci.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void okPressed() {
        this.name = this.nameField.getText().trim();
        if (this.name.isEmpty()) {
            Shell shell = this.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openWarning((Shell)shell, (String)Messages.CreateNetworkServiceDialog_Warning, (String)Messages.CreateNetworkServiceDialog_WarningEmptyName);
            return;
        }
        this.serviceType = this.serviceTypeField.getSelectionIndex();
        try {
            this.port = Integer.parseInt(this.portField.getText());
            if (this.port < 1 || this.port > 65535) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            Shell shell = this.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openWarning((Shell)shell, (String)Messages.CreateNetworkServiceDialog_Warning, (String)Messages.CreateNetworkServiceDialog_WarningInvalidPort);
            return;
        }
        this.alias = this.aliasField.getText().trim();
        this.request = this.requestField.getText();
        this.response = this.responseField.getText();
        this.createDci = this.checkCreateDci.getSelection();
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        settings.put("CreateNetworkServiceDialog.checkCreateDci", this.createDci);
        super.okPressed();
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public int getServiceType() {
        return this.serviceType;
    }

    public int getPort() {
        return this.port;
    }

    public String getRequest() {
        return this.request;
    }

    public String getResponse() {
        return this.response;
    }

    public boolean isCreateDci() {
        return this.createDci;
    }
}

