/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.widgets;

import org.eclipse.swt.widgets.Composite;
import org.netxms.client.objects.ObjectCategory;
import org.netxms.ui.eclipse.objectmanager.dialogs.ObjectCategorySelectionDialog;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.widgets.AbstractSelector;

public class ObjectCategorySelector
extends AbstractSelector {
    int categoryId = 0;

    public ObjectCategorySelector(Composite parent, int style, int options) {
        super(parent, style, options);
        this.setText("<none>");
    }

    protected void selectionButtonHandler() {
        ObjectCategory category;
        ObjectCategorySelectionDialog dlg = new ObjectCategorySelectionDialog(this.getShell());
        if (dlg.open() == 0 && (category = ConsoleSharedData.getSession().getObjectCategory(dlg.getCategoryId())) != null) {
            this.categoryId = category.getId();
            this.setText(category.getName());
        }
    }

    protected void clearButtonHandler() {
        this.categoryId = 0;
        this.setText("<none>");
    }

    public int getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(int categoryId) {
        if (categoryId == 0) {
            this.categoryId = 0;
            this.setText("<none>");
            return;
        }
        ObjectCategory category = ConsoleSharedData.getSession().getObjectCategory(categoryId);
        if (category != null) {
            this.categoryId = category.getId();
            this.setText(category.getName());
        } else {
            this.categoryId = 0;
            this.setText("<none>");
        }
    }
}

