/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum AggregationFunction {
    LAST(0),
    MIN(1),
    MAX(2),
    AVERAGE(3),
    SUM(4);

    private static Logger logger;
    private static Map<Integer, AggregationFunction> lookupTable;
    private int value;

    static {
        logger = LoggerFactory.getLogger(AggregationFunction.class);
        lookupTable = new HashMap<Integer, AggregationFunction>();
        AggregationFunction[] aggregationFunctionArray = AggregationFunction.values();
        int n = aggregationFunctionArray.length;
        int n2 = 0;
        while (n2 < n) {
            AggregationFunction element = aggregationFunctionArray[n2];
            lookupTable.put(element.value, element);
            ++n2;
        }
    }

    private AggregationFunction(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static AggregationFunction getByValue(int value) {
        AggregationFunction element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return LAST;
        }
        return element;
    }
}

