/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum TimeFrameType {
    FIXED(0),
    BACK_FROM_NOW(1);

    private static Logger logger;
    private static Map<Integer, TimeFrameType> lookupTable;
    private int value;

    static {
        logger = LoggerFactory.getLogger(TimeFrameType.class);
        lookupTable = new HashMap<Integer, TimeFrameType>();
        TimeFrameType[] timeFrameTypeArray = TimeFrameType.values();
        int n = timeFrameTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TimeFrameType element = timeFrameTypeArray[n2];
            lookupTable.put(element.value, element);
            ++n2;
        }
    }

    private TimeFrameType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static TimeFrameType getByValue(int value) {
        TimeFrameType element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return BACK_FROM_NOW;
        }
        return element;
    }
}

