/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum UserAuthenticationMethod {
    LOCAL(0),
    RADIUS(1),
    CERTIFICATE(2),
    CERTIFICATE_OR_LOCAL(3),
    CERTIFICATE_OR_RADIUS(4),
    LDAP(5);

    private static Logger logger;
    private static Map<Integer, UserAuthenticationMethod> lookupTable;
    private int value;

    static {
        logger = LoggerFactory.getLogger(UserAuthenticationMethod.class);
        lookupTable = new HashMap<Integer, UserAuthenticationMethod>();
        UserAuthenticationMethod[] userAuthenticationMethodArray = UserAuthenticationMethod.values();
        int n = userAuthenticationMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            UserAuthenticationMethod element = userAuthenticationMethodArray[n2];
            lookupTable.put(element.value, element);
            ++n2;
        }
    }

    private UserAuthenticationMethod(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static UserAuthenticationMethod getByValue(int value) {
        UserAuthenticationMethod element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return LOCAL;
        }
        return element;
    }
}

