/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import java.util.ArrayList;
import java.util.List;
import org.netxms.base.NXCPMessage;
import org.netxms.client.constants.Severity;
import org.netxms.client.datacollection.DciValue;

public class ThresholdViolationSummary {
    private long nodeId;
    private List<DciValue> dciList;

    public ThresholdViolationSummary(NXCPMessage msg, long baseId) {
        this.nodeId = msg.getFieldAsInt64(baseId);
        int count = msg.getFieldAsInt32(baseId + 1L);
        this.dciList = new ArrayList<DciValue>(count);
        long fieldId = baseId + 2L;
        int i = 0;
        while (i < count) {
            DciValue v = DciValue.createFromMessage(msg, fieldId);
            if (v.getActiveThreshold() != null) {
                this.dciList.add(v);
            }
            fieldId += 50L;
            ++i;
        }
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public List<DciValue> getDciList() {
        return this.dciList;
    }

    public Severity getCurrentSeverity() {
        Severity severity = Severity.NORMAL;
        for (DciValue v : this.dciList) {
            if (v.getActiveThreshold().getCurrentSeverity().compareTo(severity) <= 0) continue;
            severity = v.getActiveThreshold().getCurrentSeverity();
        }
        return severity;
    }
}

