/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverconfig.views.helpers;

import java.net.InetAddress;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.netxms.client.InetAddressListElement;
import org.netxms.client.NXCSession;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class AddressListElementComparator
extends ViewerComparator {
    private NXCSession session = ConsoleSharedData.getSession();
    private boolean isDiscoveryTarget;

    public AddressListElementComparator(boolean isDiscoveryTarget) {
        this.isDiscoveryTarget = isDiscoveryTarget;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int result;
        InetAddressListElement a1 = (InetAddressListElement)e1;
        InetAddressListElement a2 = (InetAddressListElement)e2;
        switch ((Integer)((SortableTableViewer)viewer).getTable().getSortColumn().getData("ID")) {
            case 0: {
                result = this.compareIpAddresses(a1.getBaseAddress(), a2.getBaseAddress());
                if (result != 0 || (result = a1.getType() - a2.getType()) != 0) break;
                result = a1.getType() == 0 ? a1.getMaskBits() - a2.getMaskBits() : this.compareIpAddresses(a1.getEndAddress(), a2.getEndAddress());
                break;
            }
            case 1: {
                if (this.isDiscoveryTarget) {
                    String name1 = a1.getProxyId() != 0L ? this.session.getObjectName(a1.getProxyId()) : this.session.getZoneName(a1.getZoneUIN());
                    String name2 = a2.getProxyId() != 0L ? this.session.getObjectName(a2.getProxyId()) : this.session.getZoneName(a2.getZoneUIN());
                    result = name1.compareTo(name2);
                    break;
                }
                result = a1.getComment().compareTo(a2.getComment());
                break;
            }
            case 2: {
                result = a1.getComment().compareTo(a2.getComment());
                break;
            }
            default: {
                result = 0;
            }
        }
        return ((SortableTableViewer)viewer).getTable().getSortDirection() == 128 ? result : -result;
    }

    private int compareIpAddresses(InetAddress a1, InetAddress a2) {
        byte[] b2;
        byte[] b1 = a1.getAddress();
        int rc = b1.length - (b2 = a2.getAddress()).length;
        if (rc != 0) {
            return rc;
        }
        int i = 0;
        while (i < b1.length) {
            rc = (b1[i] & 0xFF) - (b2[i] & 0xFF);
            if (rc != 0) {
                return Integer.signum(rc);
            }
            ++i;
        }
        return 0;
    }
}

