/*
 * Decompiled with CFR 0.152.
 */
package org.swtchart.internal.axis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.swt.SWT;
import org.swtchart.Chart;
import org.swtchart.IAxis;
import org.swtchart.IAxisSet;
import org.swtchart.ISeries;
import org.swtchart.internal.ChartLayoutData;
import org.swtchart.internal.Legend;
import org.swtchart.internal.Title;
import org.swtchart.internal.axis.Axis;
import org.swtchart.internal.series.SeriesSet;

public class AxisSet
implements IAxisSet {
    private HashMap<Integer, Axis> xAxisMap;
    private HashMap<Integer, Axis> yAxisMap;
    private Chart chart;

    public AxisSet(Chart chart) {
        this.chart = chart;
        this.xAxisMap = new HashMap();
        this.yAxisMap = new HashMap();
        Axis xAxis = new Axis(0, IAxis.Direction.X, chart);
        Axis yAxis = new Axis(0, IAxis.Direction.Y, chart);
        this.xAxisMap.put(0, xAxis);
        this.yAxisMap.put(0, yAxis);
    }

    private HashMap<Integer, Axis> getAxisMap(IAxis.Direction direction) {
        if (direction == IAxis.Direction.X) {
            return this.xAxisMap;
        }
        return this.yAxisMap;
    }

    @Override
    public int createXAxis() {
        return this.createAxis(IAxis.Direction.X);
    }

    @Override
    public int createYAxis() {
        return this.createAxis(IAxis.Direction.Y);
    }

    private int createAxis(IAxis.Direction direction) {
        int id = this.getUniqueId(direction);
        Axis axis = new Axis(id, direction, this.chart);
        this.getAxisMap(direction).put(id, axis);
        this.chart.updateLayout();
        SeriesSet series = (SeriesSet)this.chart.getSeriesSet();
        if (series != null) {
            series.compressAllSeries();
        }
        return id;
    }

    private int getUniqueId(IAxis.Direction direction) {
        Set<Integer> keySet = this.getAxisMap(direction).keySet();
        int i = 0;
        while (keySet.contains(i)) {
            ++i;
        }
        return i;
    }

    @Override
    public IAxis getXAxis(int id) {
        return this.getAxis(id, IAxis.Direction.X);
    }

    @Override
    public IAxis getYAxis(int id) {
        return this.getAxis(id, IAxis.Direction.Y);
    }

    private IAxis getAxis(int id, IAxis.Direction direction) {
        return this.getAxisMap(direction).get(id);
    }

    @Override
    public IAxis[] getXAxes() {
        return this.xAxisMap.values().toArray(new IAxis[0]);
    }

    @Override
    public IAxis[] getYAxes() {
        return this.yAxisMap.values().toArray(new IAxis[0]);
    }

    @Override
    public IAxis[] getAxes() {
        ArrayList<Axis> axes = new ArrayList<Axis>();
        axes.addAll(this.xAxisMap.values());
        axes.addAll(this.yAxisMap.values());
        return axes.toArray(new Axis[0]);
    }

    @Override
    public int[] getXAxisIds() {
        return this.getAxisIds(IAxis.Direction.X);
    }

    @Override
    public int[] getYAxisIds() {
        return this.getAxisIds(IAxis.Direction.Y);
    }

    private int[] getAxisIds(IAxis.Direction direction) {
        Integer[] array = this.getAxisMap(direction).keySet().toArray(new Integer[0]);
        int[] ids = new int[array.length];
        int i = 0;
        while (i < ids.length) {
            ids[i] = array[i];
            ++i;
        }
        Arrays.sort(ids);
        return ids;
    }

    @Override
    public void deleteXAxis(int id) {
        this.deleteAxis(id, IAxis.Direction.X);
    }

    @Override
    public void deleteYAxis(int id) {
        this.deleteAxis(id, IAxis.Direction.Y);
    }

    private void deleteAxis(int id, IAxis.Direction direction) {
        if (id == 0) {
            SWT.error((int)7);
        }
        if (this.getAxisMap(direction).get(id) == null) {
            throw new IllegalArgumentException("Given axis id doesn't exist");
        }
        ((Axis)this.getAxis(id, direction)).dispose();
        this.getAxisMap(direction).remove(id);
        ISeries[] iSeriesArray = this.chart.getSeriesSet().getSeries();
        int n = iSeriesArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISeries series = iSeriesArray[n2];
            if (direction == IAxis.Direction.X) {
                if (series.getXAxisId() == id) {
                    series.setXAxisId(0);
                }
            } else if (series.getYAxisId() == id) {
                series.setYAxisId(0);
            }
            ++n2;
        }
        this.chart.updateLayout();
    }

    @Override
    public void adjustRange() {
        IAxis[] iAxisArray = this.getAxes();
        int n = iAxisArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAxis axis = iAxisArray[n2];
            ((Axis)axis).adjustRange(false);
            ++n2;
        }
        this.chart.updateLayout();
    }

    @Override
    public void zoomIn() {
        IAxis[] iAxisArray = this.getAxes();
        int n = iAxisArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAxis axis = iAxisArray[n2];
            axis.zoomIn();
            ++n2;
        }
    }

    @Override
    public void zoomOut() {
        IAxis[] iAxisArray = this.getAxes();
        int n = iAxisArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAxis axis = iAxisArray[n2];
            axis.zoomOut();
            ++n2;
        }
    }

    public void updateLayoutData() {
        IAxis[] verticalAxes;
        IAxis[] horizontalAxes;
        if (this.chart.getOrientation() == 256) {
            horizontalAxes = this.getXAxes();
            verticalAxes = this.getYAxes();
        } else {
            horizontalAxes = this.getYAxes();
            verticalAxes = this.getXAxes();
        }
        this.updateAxesLayoutData(horizontalAxes);
        this.updateVerticalTick(horizontalAxes, verticalAxes);
        this.updateAxesLayoutData(verticalAxes);
        this.updateHorizontalTick(horizontalAxes, verticalAxes);
    }

    private void updateAxesLayoutData(IAxis[] axes) {
        IAxis[] iAxisArray = axes;
        int n = axes.length;
        int n2 = 0;
        while (n2 < n) {
            IAxis axis = iAxisArray[n2];
            ((Axis)axis).updateLayoutData();
            ++n2;
        }
    }

    private void updateHorizontalTick(IAxis[] horizontalAxes, IAxis[] verticalAxes) {
        int legendPosition = ((Legend)this.chart.getLegend()).getPosition();
        int legendWidth = ((ChartLayoutData)((Legend)this.chart.getLegend()).getLayoutData()).widthHint;
        int axesWidth = 0;
        IAxis[] iAxisArray = verticalAxes;
        int n = verticalAxes.length;
        int n2 = 0;
        while (n2 < n) {
            IAxis axis = iAxisArray[n2];
            axesWidth += ((ChartLayoutData)((Title)((Axis)axis).getTitle()).getLayoutData()).widthHint + ((Axis)axis).getTick().getAxisTickLabels().getLayoutData().widthHint + ((Axis)axis).getTick().getAxisTickMarks().getLayoutData().widthHint;
            ++n2;
        }
        int axisWidth = this.chart.getSize().x - axesWidth - 10 - (legendPosition == 16384 || legendPosition == 131072 ? legendWidth + (legendWidth == 0 ? 0 : 5) : 0);
        IAxis[] iAxisArray2 = horizontalAxes;
        int n3 = horizontalAxes.length;
        n = 0;
        while (n < n3) {
            IAxis axis = iAxisArray2[n];
            ((Axis)axis).getTick().updateTick(axisWidth);
            ++n;
        }
    }

    private void updateVerticalTick(IAxis[] horizontalAxes, IAxis[] verticalAxes) {
        int legendPosition = ((Legend)this.chart.getLegend()).getPosition();
        int legendHeight = ((ChartLayoutData)((Legend)this.chart.getLegend()).getLayoutData()).heightHint;
        int titleHeight = ((ChartLayoutData)((Title)this.chart.getTitle()).getLayoutData()).heightHint;
        int axesHeight = 0;
        IAxis[] iAxisArray = horizontalAxes;
        int n = horizontalAxes.length;
        int n2 = 0;
        while (n2 < n) {
            IAxis axis = iAxisArray[n2];
            axesHeight += ((ChartLayoutData)((Title)((Axis)axis).getTitle()).getLayoutData()).heightHint + ((Axis)axis).getTick().getAxisTickLabels().getLayoutData().heightHint + ((Axis)axis).getTick().getAxisTickMarks().getLayoutData().heightHint;
            ++n2;
        }
        int axisHeight = this.chart.getSize().y - titleHeight - axesHeight - 10 - (titleHeight == 0 ? 0 : 5) - (legendPosition == 128 || legendPosition == 1024 ? legendHeight + (legendHeight == 0 ? 0 : 5) : 0);
        IAxis[] iAxisArray2 = verticalAxes;
        int n3 = verticalAxes.length;
        n = 0;
        while (n < n3) {
            IAxis axis = iAxisArray2[n];
            ((Axis)axis).getTick().updateTick(axisHeight);
            ++n;
        }
    }

    public void refresh() {
        IAxis[] iAxisArray = this.getAxes();
        int n = iAxisArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAxis axis = iAxisArray[n2];
            ((Axis)axis).refresh();
            ++n2;
        }
    }

    public void dispose() {
        IAxis[] iAxisArray = this.getAxes();
        int n = iAxisArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAxis axis = iAxisArray[n2];
            ((Axis)axis).dispose();
            ++n2;
        }
    }
}

