/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps;

import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.networkmaps.api.NetworkMapImageProvider;

public class MapImageProvidersManager {
    private static MapImageProvidersManager instance = null;
    private Map<Integer, NetworkMapImageProvider> providers = new TreeMap<Integer, NetworkMapImageProvider>();

    public static MapImageProvidersManager getInstance() {
        return instance;
    }

    protected static void create() {
        if (instance == null) {
            instance = new MapImageProvidersManager();
        }
    }

    private MapImageProvidersManager() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = reg.getConfigurationElementsFor("org.netxms.ui.eclipse.networkmaps.imageproviders");
        int i = 0;
        while (i < elements.length) {
            try {
                NetworkMapImageProvider p = (NetworkMapImageProvider)elements[i].createExecutableExtension("class");
                int priority = 65535;
                String value = elements[i].getAttribute("priority");
                if (value != null) {
                    try {
                        priority = Integer.parseInt(value);
                        if (priority < 0) {
                            priority = 65535;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                this.providers.put(priority, p);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public Image getMapImage(AbstractObject object) {
        for (NetworkMapImageProvider p : this.providers.values()) {
            Image i = p.getMapImage(object);
            if (i == null) continue;
            return i;
        }
        return null;
    }

    public Image getStatusIcon(ObjectStatus status) {
        for (NetworkMapImageProvider p : this.providers.values()) {
            Image i = p.getStatusIcon(status);
            if (i == null) continue;
            return i;
        }
        return null;
    }
}

