/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.views;

import java.util.Iterator;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.netxms.client.maps.NetworkMapLink;
import org.netxms.client.maps.NetworkMapPage;
import org.netxms.client.maps.elements.NetworkMapElement;
import org.netxms.client.maps.elements.NetworkMapObject;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Node;
import org.netxms.client.objects.Subnet;
import org.netxms.client.objects.VPNConnector;
import org.netxms.ui.eclipse.networkmaps.Messages;
import org.netxms.ui.eclipse.networkmaps.views.AbstractNetworkMapView;

public class IPNeighbors
extends AbstractNetworkMapView {
    public static final String ID = "org.netxms.ui.eclipse.networkmaps.view.ip_neighbors";

    @Override
    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        Messages.get();
        this.setPartName(String.valueOf(Messages.IPNeighbors_PartName) + this.rootObject.getObjectName());
    }

    @Override
    protected void buildMapPage() {
        this.mapPage = new NetworkMapPage("org.netxms.ui.eclipse.networkmaps.view.ip_neighbors." + ((Object)((Object)this)).toString());
        long rootElementId = this.mapPage.createElementId();
        this.mapPage.addElement((NetworkMapElement)new NetworkMapObject(rootElementId, this.rootObject.getObjectId()));
        this.addSubnets(this.rootObject, rootElementId);
        long[] lArray = this.rootObject.getChildIdList();
        int n = lArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractObject peer;
            long objectId = lArray[n2];
            AbstractObject object = this.session.findObjectById(objectId);
            if (object != null && object instanceof VPNConnector && (peer = this.session.findObjectById(((VPNConnector)object).getPeerGatewayId())) != null) {
                long elementId = this.mapPage.createElementId();
                this.mapPage.addElement((NetworkMapElement)new NetworkMapObject(elementId, peer.getObjectId()));
                NetworkMapLink link = new NetworkMapLink(this.mapPage.createLinkId(), 1, rootElementId, elementId);
                link.setName(object.getObjectName());
                this.mapPage.addLink(link);
                this.addSubnets(peer, elementId);
            }
            ++n2;
        }
        this.addDciToRequestList();
    }

    private void addSubnets(AbstractObject root, long rootElementId) {
        long[] lArray = root.getParentIdList();
        int n = lArray.length;
        int n2 = 0;
        while (n2 < n) {
            long objectId = lArray[n2];
            AbstractObject object = this.session.findObjectById(objectId);
            if (object != null && object instanceof Subnet) {
                long elementId = this.mapPage.createElementId();
                this.mapPage.addElement((NetworkMapElement)new NetworkMapObject(elementId, objectId));
                this.mapPage.addLink(new NetworkMapLink(this.mapPage.createLinkId(), 0, rootElementId, elementId));
                this.addNodesFromSubnet((Subnet)object, elementId, root.getObjectId());
            }
            ++n2;
        }
    }

    private void addNodesFromSubnet(Subnet subnet, long subnetElementId, long rootNodeId) {
        Iterator it = subnet.getChildren();
        while (it.hasNext()) {
            AbstractObject object;
            long objectId = (Long)it.next();
            if (objectId == rootNodeId || (object = this.session.findObjectById(objectId)) == null || !(object instanceof Node)) continue;
            long elementId = this.mapPage.createElementId();
            this.mapPage.addElement((NetworkMapElement)new NetworkMapObject(elementId, objectId));
            this.mapPage.addLink(new NetworkMapLink(this.mapPage.createLinkId(), 0, subnetElementId, elementId));
        }
        this.addDciToRequestList();
    }
}

