/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.views.helpers;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.jface.resource.JFaceResources;
import org.netxms.base.MacAddress;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.maps.MapObjectDisplayMode;
import org.netxms.client.maps.elements.NetworkMapObject;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.AccessPoint;
import org.netxms.client.objects.DataCollectionTarget;
import org.netxms.client.objects.Node;
import org.netxms.client.objects.UnknownObject;
import org.netxms.client.topology.RadioInterface;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.console.resources.ThemeEngine;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.networkmaps.Activator;
import org.netxms.ui.eclipse.networkmaps.Messages;
import org.netxms.ui.eclipse.networkmaps.views.helpers.MapLabelProvider;
import org.netxms.ui.eclipse.networkmaps.views.helpers.NodeLastValuesFigure;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ObjectTooltip
extends Figure {
    private NXCSession session = ConsoleSharedData.getSession();
    private NodeLastValuesFigure lastValuesFigure = null;
    private int index;
    private AbstractObject object;
    private MapLabelProvider labelProvider;
    private long refreshTimestamp = 0L;

    public ObjectTooltip(NetworkMapObject element, MapLabelProvider labelProvider) {
        DciValue[] values;
        MacAddress mac;
        StringBuilder sb;
        this.labelProvider = labelProvider;
        this.object = this.session.findObjectById(element.getObjectId());
        if (this.object == null) {
            this.object = new UnknownObject(element.getObjectId(), this.session);
        }
        this.setBorder((Border)new MarginBorder(3));
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 10;
        this.setLayoutManager((LayoutManager)layout);
        this.setOpaque(true);
        this.setBackgroundColor(ThemeEngine.getBackgroundColor((String)"Map.ObjectTooltip"));
        Label title = new Label();
        title.setIcon(labelProvider.getWorkbenchIcon(this.object));
        title.setText(this.object.getObjectName());
        title.setFont(JFaceResources.getBannerFont());
        this.add((IFigure)title);
        Label status = new Label();
        status.setIcon(StatusDisplayInfo.getStatusImage((ObjectStatus)this.object.getStatus()));
        status.setText(StatusDisplayInfo.getStatusText((ObjectStatus)this.object.getStatus()));
        this.add((IFigure)status);
        GridData gd = new GridData();
        gd.horizontalAlignment = 131072;
        this.setConstraint((IFigure)status, gd);
        if (this.object instanceof Node) {
            if ((((Node)this.object).getCapabilities() & 0x800000L) != 0L) {
                if (((Node)this.object).getHardwareProductName() != null && !((Node)this.object).getHardwareProductName().isEmpty()) {
                    this.addInformationBlock(String.valueOf(((Node)this.object).getHardwareProductName()) + " (" + ((Node)this.object).getCipDeviceTypeName() + ")", null);
                } else {
                    this.addInformationBlock(((Node)this.object).getCipDeviceTypeName(), null);
                }
            } else {
                this.addInformationBlock(((Node)this.object).getHardwareProductName(), null);
            }
            this.addInformationBlock(((Node)this.object).getHardwareVendor(), "Vendor: ");
        }
        if (this.object instanceof Node && ((Node)this.object).getPrimaryIP().isValidAddress() && !((Node)this.object).getPrimaryIP().getAddress().isAnyLocalAddress()) {
            sb = new StringBuilder(((Node)this.object).getPrimaryIP().getHostAddress());
            mac = ((Node)this.object).getPrimaryMAC();
            if (mac != null) {
                sb.append(" (");
                sb.append(mac.toString());
                sb.append(')');
            }
            Label iface = new Label();
            iface.setIcon(SharedIcons.IMG_IP_ADDRESS);
            iface.setText(sb.toString());
            this.add((IFigure)iface);
            gd = new GridData();
            gd.horizontalSpan = 2;
            this.setConstraint((IFigure)iface, gd);
        }
        this.index = this.getChildren().size();
        if (this.object instanceof Node && labelProvider.getObjectFigureType() == MapObjectDisplayMode.LARGE_LABEL && (values = labelProvider.getNodeLastValues(this.object.getObjectId())) != null && values.length > 0) {
            this.lastValuesFigure = new NodeLastValuesFigure(values);
            this.add((IFigure)this.lastValuesFigure);
            gd = new GridData();
            gd.horizontalSpan = 2;
            this.setConstraint((IFigure)this.lastValuesFigure, gd);
        }
        if (this.object instanceof AccessPoint) {
            sb = new StringBuilder(((AccessPoint)this.object).getModel());
            mac = ((AccessPoint)this.object).getMacAddress();
            if (mac != null) {
                sb.append('\n');
                sb.append(mac.toString());
            }
            RadioInterface[] radioInterfaceArray = ((AccessPoint)this.object).getRadios();
            int n = radioInterfaceArray.length;
            int n2 = 0;
            while (n2 < n) {
                RadioInterface rif = radioInterfaceArray[n2];
                Messages.get();
                sb.append(Messages.ObjectTooltip_Radio);
                sb.append(rif.getIndex());
                sb.append(" (");
                sb.append(rif.getBSSID().toString());
                Messages.get();
                sb.append(Messages.ObjectTooltip_Channel);
                sb.append(rif.getChannel());
                Messages.get();
                sb.append(Messages.ObjectTooltip_TXPower);
                sb.append(rif.getPowerMW());
                Messages.get();
                sb.append(Messages.ObjectTooltip_mW);
                ++n2;
            }
            Label info = new Label();
            info.setText(sb.toString());
            this.add((IFigure)info);
            gd = new GridData();
            gd.horizontalSpan = 2;
            this.setConstraint((IFigure)info, gd);
        }
        if (!this.object.getComments().isEmpty()) {
            FlowPage page = new FlowPage();
            this.add((IFigure)page);
            gd = new GridData();
            gd.horizontalSpan = 2;
            this.setConstraint((IFigure)page, gd);
            TextFlow text = new TextFlow();
            text.setText("\n" + this.object.getComments());
            page.add((IFigure)text);
        }
    }

    public void refresh() {
        long now = System.currentTimeMillis();
        if (now < this.refreshTimestamp + 15000L) {
            return;
        }
        this.refreshTimestamp = now;
        if (this.labelProvider.getObjectFigureType() == MapObjectDisplayMode.LARGE_LABEL || !(this.object instanceof DataCollectionTarget)) {
            return;
        }
        final long nodeId = this.object.getObjectId();
        ConsoleJob job = new ConsoleJob("Get DCI data for object tooltip", null, "org.netxms.ui.eclipse.networkmaps", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                try {
                    final DciValue[] values = ObjectTooltip.this.session.getDataCollectionSummary(nodeId, true, false, false);
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            if ((this).ObjectTooltip.this.object instanceof Node && values != null && values.length > 0) {
                                if ((this).ObjectTooltip.this.lastValuesFigure != null) {
                                    ObjectTooltip.this.remove((IFigure)(this).ObjectTooltip.this.lastValuesFigure);
                                }
                                (this).ObjectTooltip.this.lastValuesFigure = new NodeLastValuesFigure(values);
                                GridData gd = new GridData();
                                gd.horizontalSpan = 2;
                                ObjectTooltip.this.add((IFigure)(this).ObjectTooltip.this.lastValuesFigure, gd, (this).ObjectTooltip.this.index);
                                ObjectTooltip.this.layout();
                                (this).ObjectTooltip.this.labelProvider.getViewer().resizeToolTipShell();
                            }
                        }
                    });
                }
                catch (Exception e) {
                    Activator.logError("Exception while reading data for object tooltip", e);
                }
            }

            protected String getErrorMessage() {
                return null;
            }
        };
        job.setUser(false);
        job.setSystem(true);
        job.start();
    }

    private void addInformationBlock(String text, String prefix) {
        if (text == null || text.isEmpty()) {
            return;
        }
        Label info = new Label();
        info.setText(prefix != null ? String.valueOf(prefix) + text : text);
        this.add((IFigure)info);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.setConstraint((IFigure)info, gd);
    }
}

