/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IEvaluationService;
import org.eclipse.ui.services.IServiceLocator;
import org.netxms.client.NXCSession;
import org.netxms.client.Table;
import org.netxms.client.datacollection.DciSummaryTableDescriptor;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.EntireNetwork;
import org.netxms.client.objects.ServiceRoot;
import org.netxms.client.objects.Subnet;
import org.netxms.client.objects.Zone;
import org.netxms.client.objects.queries.ObjectQueryResult;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.api.SummaryTablesCache;
import org.netxms.ui.eclipse.datacollection.views.SummaryTable;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class SummaryTablesDynamicMenu
extends ContributionItem
implements IWorkbenchContribution {
    private IEvaluationService evalService;

    public SummaryTablesDynamicMenu() {
    }

    public SummaryTablesDynamicMenu(String id) {
        super(id);
    }

    public void initialize(IServiceLocator serviceLocator) {
        this.evalService = (IEvaluationService)serviceLocator.getService(IEvaluationService.class);
    }

    public void fill(Menu menu, int index) {
        AbstractObject baseObject;
        Object selection = this.evalService.getCurrentState().getVariable("activeMenuSelection");
        if (selection == null || !(selection instanceof IStructuredSelection)) {
            return;
        }
        Object selectedElement = ((IStructuredSelection)selection).getFirstElement();
        AbstractObject abstractObject = baseObject = selectedElement instanceof ObjectQueryResult ? ((ObjectQueryResult)selectedElement).getObject() : (AbstractObject)selectedElement;
        if (!(baseObject instanceof Container || baseObject instanceof Cluster || baseObject instanceof ServiceRoot || baseObject instanceof Subnet || baseObject instanceof Zone || baseObject instanceof EntireNetwork)) {
            return;
        }
        Menu tablesMenu = new Menu(menu);
        DciSummaryTableDescriptor[] tables = SummaryTablesCache.getInstance().getTables();
        Arrays.sort(tables, new Comparator<DciSummaryTableDescriptor>(){

            @Override
            public int compare(DciSummaryTableDescriptor d1, DciSummaryTableDescriptor d2) {
                return d1.getMenuPath().replace("&", "").compareToIgnoreCase(d2.getMenuPath().replace("&", ""));
            }
        });
        HashMap<String, Menu> menus = new HashMap<String, Menu>();
        int added = 0;
        int i = 0;
        while (i < tables.length) {
            if (!tables[i].getMenuPath().isEmpty()) {
                String[] path = tables[i].getMenuPath().split("\\-\\>");
                Menu rootMenu = tablesMenu;
                int j = 0;
                while (j < path.length - 1) {
                    String key = String.valueOf(rootMenu.hashCode()) + "@" + path[j].replace("&", "");
                    Menu currMenu = (Menu)menus.get(key);
                    if (currMenu == null) {
                        currMenu = new Menu(rootMenu);
                        MenuItem item = new MenuItem(rootMenu, 64);
                        item.setText(path[j]);
                        item.setMenu(currMenu);
                        menus.put(key, currMenu);
                    }
                    rootMenu = currMenu;
                    ++j;
                }
                final MenuItem item = new MenuItem(rootMenu, 8);
                item.setText(path[path.length - 1]);
                item.setData((Object)tables[i]);
                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        SummaryTablesDynamicMenu.this.queryTable(baseObject.getObjectId(), ((DciSummaryTableDescriptor)item.getData()).getId());
                    }
                });
                ++added;
            }
            ++i;
        }
        if (added > 0) {
            MenuItem tablesMenuItem = new MenuItem(menu, 64, index);
            Messages.get();
            tablesMenuItem.setText(Messages.SummaryTablesDynamicMenu_MenuName);
            tablesMenuItem.setMenu(tablesMenu);
        } else {
            tablesMenu.dispose();
        }
    }

    private void queryTable(final long baseObjectId, final int tableId) {
        final NXCSession session = ConsoleSharedData.getSession();
        Messages.get();
        new ConsoleJob(Messages.SummaryTablesDynamicMenu_QueryTableJob, null, "org.netxms.ui.eclipse.datacollection", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final Table results = session.queryDciSummaryTable(tableId, baseObjectId);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        String secondaryId = String.valueOf(Integer.toString(tableId)) + "&" + Long.toString(baseObjectId);
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        try {
                            SummaryTable view = (SummaryTable)window.getActivePage().showView("org.netxms.ui.eclipse.datacollection.views.SummaryTable", secondaryId, 1);
                            view.setTable(results);
                        }
                        catch (PartInitException e) {
                            Shell shell = window.getShell();
                            Messages.get();
                            Messages.get();
                            MessageDialogHelper.openError((Shell)shell, (String)Messages.SummaryTablesDynamicMenu_Error, (String)String.format(Messages.SummaryTablesDynamicMenu_CannotOpenView, e.getLocalizedMessage()));
                        }
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.SummaryTablesDynamicMenu_CannotReadData;
            }
        }.start();
    }
}

