/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.dialogs;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.AgentParameter;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.DataOrigin;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Template;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.dialogs.AbstractSelectParamDlg;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class SelectAgentParamDlg
extends AbstractSelectParamDlg {
    private DataOrigin origin;
    private Button queryButton;
    private Action actionQuery;
    private AbstractObject queryObject;

    public SelectAgentParamDlg(Shell parentShell, long nodeId, DataOrigin origin, boolean selectTables) {
        super(parentShell, nodeId, selectTables);
        this.origin = origin;
        this.queryObject = this.object;
        Messages.get();
        this.actionQuery = new Action(Messages.SelectAgentParamDlg_Query){

            public void run() {
                SelectAgentParamDlg.this.querySelectedParameter();
            }
        };
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (!this.selectTables) {
            ++((GridLayout)parent.getLayout()).numColumns;
            this.queryButton = new Button(parent, 8);
            Messages.get();
            this.queryButton.setText(Messages.SelectAgentParamDlg_Query);
            GridData gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.queryButton.setLayoutData((Object)gd);
            this.queryButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    SelectAgentParamDlg.this.querySelectedParameter();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
        }
        super.createButtonsForButtonBar(parent);
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        super.fillContextMenu(manager);
        if (!this.selectTables) {
            manager.add((IAction)this.actionQuery);
        }
    }

    @Override
    protected void fillList() {
        final NXCSession session = ConsoleSharedData.getSession();
        Messages.get();
        new ConsoleJob(String.valueOf(Messages.SelectAgentParamDlg_JobTitle) + this.object.getObjectName(), null, "org.netxms.ui.eclipse.datacollection", null){

            protected String getErrorMessage() {
                Messages.get();
                return Messages.SelectAgentParamDlg_JobError;
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                if (SelectAgentParamDlg.this.selectTables) {
                    final List tables = session.getSupportedTables(SelectAgentParamDlg.this.object.getObjectId());
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            (this).SelectAgentParamDlg.this.viewer.setInput((Object)tables.toArray());
                        }
                    });
                } else {
                    final List parameters = session.getSupportedParameters(SelectAgentParamDlg.this.object.getObjectId(), SelectAgentParamDlg.this.origin);
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            (this).SelectAgentParamDlg.this.viewer.setInput((Object)parameters.toArray());
                        }
                    });
                }
            }
        }.start();
    }

    protected void querySelectedParameter() {
        String n;
        AgentParameter p;
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        if (this.queryObject instanceof Template) {
            ObjectSelectionDialog sDlg = new ObjectSelectionDialog(this.getShell(), ObjectSelectionDialog.createNodeSelectionFilter((boolean)false));
            sDlg.enableMultiSelection(false);
            if (sDlg.open() == 0) {
                this.queryObject = (AbstractObject)sDlg.getSelectedObjects().get(0);
            }
        }
        if ((p = (AgentParameter)selection.getFirstElement()).getName().contains("(*)")) {
            Shell shell = this.getShell();
            Messages.get();
            Messages.get();
            InputDialog dlg = new InputDialog(shell, Messages.SelectAgentParamDlg_InstanceTitle, Messages.SelectAgentParamDlg_InstanceMessage, "", null);
            if (dlg.open() != 0) {
                return;
            }
            n = p.getName().replace("(*)", "(" + dlg.getValue() + ")");
        } else {
            n = p.getName();
        }
        final NXCSession session = ConsoleSharedData.getSession();
        final String name = n;
        Messages.get();
        new ConsoleJob(Messages.SelectAgentParamDlg_QueryJobTitle, null, "org.netxms.ui.eclipse.datacollection"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                String value = session.queryMetric(SelectAgentParamDlg.this.queryObject.getObjectId(), SelectAgentParamDlg.this.origin, name);
                this.runInUIThread(() -> {
                    Shell shell = SelectAgentParamDlg.this.getShell();
                    Messages.get();
                    Messages.get();
                    MessageDialogHelper.openInformation((Shell)shell, (String)Messages.SelectAgentParamDlg_CurrentValueTitle, (String)String.format(Messages.SelectAgentParamDlg_CurrentValue, value));
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.SelectAgentParamDlg_QueryError;
            }
        }.start();
    }

    @Override
    protected String getConfigurationPrefix() {
        return String.valueOf(this.selectTables ? "SelectAgentTableDlg." : "SelectAgentParamDlg.") + this.origin;
    }
}

