/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.propertypages;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.netxms.client.constants.DataOrigin;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.client.datacollection.DataCollectionObject;
import org.netxms.client.snmp.SnmpVersion;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.propertypages.helpers.AbstractDCIPropertyPage;

public class SNMP
extends AbstractDCIPropertyPage {
    private DataCollectionObject dco;
    private Button checkInterpretRawSnmpValue;
    private Combo snmpRawType;
    private Button checkUseCustomSnmpPort;
    private Spinner customSnmpPort;
    private Button checkUseCustomSnmpVersion;
    private Combo customSnmpVersion;
    private static final String[] snmpRawTypes;

    static {
        String[] stringArray = new String[9];
        Messages.get();
        stringArray[0] = Messages.General_SNMP_DT_None;
        Messages.get();
        stringArray[1] = Messages.General_SNMP_DT_int32;
        Messages.get();
        stringArray[2] = Messages.General_SNMP_DT_uint32;
        Messages.get();
        stringArray[3] = Messages.General_SNMP_DT_int64;
        Messages.get();
        stringArray[4] = Messages.General_SNMP_DT_uint64;
        Messages.get();
        stringArray[5] = Messages.General_SNMP_DT_float;
        Messages.get();
        stringArray[6] = Messages.General_SNMP_DT_ipAddr;
        Messages.get();
        stringArray[7] = Messages.General_SNMP_DT_macAddr;
        stringArray[8] = "IPv6 address";
        snmpRawTypes = stringArray;
    }

    @Override
    protected Control createContents(Composite parent) {
        Composite pageArea = (Composite)super.createContents(parent);
        this.dco = this.editor.getObject();
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        pageArea.setLayout((Layout)layout);
        GridData gd = null;
        if (this.dco instanceof DataCollectionItem) {
            this.checkInterpretRawSnmpValue = new Button(pageArea, 32);
            Messages.get();
            this.checkInterpretRawSnmpValue.setText(Messages.General_InterpretRawValue);
            this.checkInterpretRawSnmpValue.setSelection(((DataCollectionItem)this.dco).isSnmpRawValueInOctetString());
            this.checkInterpretRawSnmpValue.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    SNMP.this.snmpRawType.setEnabled(SNMP.this.checkInterpretRawSnmpValue.getSelection());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            this.snmpRawType = new Combo(pageArea, 2056);
            int i = 0;
            while (i < snmpRawTypes.length) {
                this.snmpRawType.add(snmpRawTypes[i]);
                ++i;
            }
            this.snmpRawType.select(((DataCollectionItem)this.dco).getSnmpRawValueType());
            this.snmpRawType.setEnabled(this.dco.getOrigin() == DataOrigin.SNMP && ((DataCollectionItem)this.dco).isSnmpRawValueInOctetString());
            gd = new GridData();
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalAlignment = 4;
            this.snmpRawType.setLayoutData((Object)gd);
        }
        this.checkUseCustomSnmpPort = new Button(pageArea, 32);
        Messages.get();
        this.checkUseCustomSnmpPort.setText(Messages.General_UseCustomPort);
        this.checkUseCustomSnmpPort.setSelection(this.dco.getSnmpPort() != 0);
        this.checkUseCustomSnmpPort.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SNMP.this.customSnmpPort.setEnabled(SNMP.this.checkUseCustomSnmpPort.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.customSnmpPort = new Spinner(pageArea, 2048);
        this.customSnmpPort.setMinimum(1);
        this.customSnmpPort.setMaximum(65535);
        if (this.dco.getOrigin() == DataOrigin.SNMP && this.dco.getSnmpPort() != 0) {
            this.customSnmpPort.setEnabled(true);
            this.customSnmpPort.setSelection(this.dco.getSnmpPort());
        } else {
            this.customSnmpPort.setEnabled(false);
        }
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.customSnmpPort.setLayoutData((Object)gd);
        this.checkUseCustomSnmpVersion = new Button(pageArea, 32);
        this.checkUseCustomSnmpVersion.setText("Use custom SNMP version:");
        this.checkUseCustomSnmpVersion.setSelection(this.dco.getSnmpVersion() != SnmpVersion.DEFAULT);
        this.checkUseCustomSnmpVersion.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SNMP.this.customSnmpVersion.setEnabled(SNMP.this.checkUseCustomSnmpVersion.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.customSnmpVersion = new Combo(pageArea, 2056);
        this.customSnmpVersion.add("1");
        this.customSnmpVersion.add("2c");
        this.customSnmpVersion.add("3");
        this.customSnmpVersion.select(SNMP.indexFromSnmpVersion(this.dco.getSnmpVersion()));
        this.customSnmpVersion.setEnabled(this.dco.getSnmpVersion() != SnmpVersion.DEFAULT);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.customSnmpVersion.setLayoutData((Object)gd);
        return pageArea;
    }

    private static int indexFromSnmpVersion(SnmpVersion version) {
        switch (version) {
            case V1: {
                return 0;
            }
            case V2C: {
                return 1;
            }
            case V3: {
                return 2;
            }
        }
        return -1;
    }

    private static SnmpVersion indexToSnmpVersion(int index) {
        switch (index) {
            case 0: {
                return SnmpVersion.V1;
            }
            case 1: {
                return SnmpVersion.V2C;
            }
            case 2: {
                return SnmpVersion.V3;
            }
        }
        return SnmpVersion.DEFAULT;
    }

    protected void applyChanges(boolean isApply) {
        if (this.dco instanceof DataCollectionItem) {
            ((DataCollectionItem)this.dco).setSnmpRawValueInOctetString(this.checkInterpretRawSnmpValue.getSelection());
            ((DataCollectionItem)this.dco).setSnmpRawValueType(this.snmpRawType.getSelectionIndex());
        }
        if (this.checkUseCustomSnmpPort.getSelection()) {
            this.dco.setSnmpPort(this.customSnmpPort.getSelection());
        } else {
            this.dco.setSnmpPort(0);
        }
        if (this.checkUseCustomSnmpVersion.getSelection()) {
            this.dco.setSnmpVersion(SNMP.indexToSnmpVersion(this.customSnmpVersion.getSelectionIndex()));
        } else {
            this.dco.setSnmpVersion(SnmpVersion.DEFAULT);
        }
        this.editor.modify();
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    protected void performDefaults() {
        super.performDefaults();
        if (this.dco instanceof DataCollectionItem) {
            this.checkInterpretRawSnmpValue.setSelection(false);
        }
        this.checkUseCustomSnmpPort.setSelection(false);
        this.customSnmpPort.setSelection(161);
    }
}

