/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.propertypages;

import java.util.Arrays;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.constants.DataType;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.ui.eclipse.console.resources.DataCollectionDisplayInfo;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.dialogs.TestTransformationDlg;
import org.netxms.ui.eclipse.datacollection.propertypages.helpers.AbstractDCIPropertyPage;
import org.netxms.ui.eclipse.nxsl.widgets.ScriptEditor;
import org.netxms.ui.eclipse.tools.WidgetFactory;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledCombo;

public class Transformation
extends AbstractDCIPropertyPage {
    private static final String[] DCI_FUNCTIONS = new String[]{"FindDCIByName", "FindDCIByDescription", "GetDCIObject", "GetDCIValue", "GetDCIValueByDescription", "GetDCIValueByName"};
    private static final String[] DCI_VARIABLES = new String[]{"$dci", "$node"};
    private LabeledCombo transformedDataType;
    private LabeledCombo deltaCalculation;
    private ScriptEditor transformationScript;
    private Button testScriptButton;
    private static final DataType[] TYPES = new DataType[]{DataType.NULL, DataType.INT32, DataType.UINT32, DataType.COUNTER32, DataType.INT64, DataType.UINT64, DataType.COUNTER64, DataType.FLOAT, DataType.STRING};

    @Override
    protected Control createContents(Composite parent) {
        String string;
        Composite dialogArea = (Composite)super.createContents(parent);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        if (this.editor.getObject() instanceof DataCollectionItem) {
            this.transformedDataType = new LabeledCombo(dialogArea, 0);
            this.transformedDataType.setLabel("Data type after transformation");
            this.transformedDataType.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.transformedDataType.add("Same as original");
            this.transformedDataType.add(DataCollectionDisplayInfo.getDataTypeName((DataType)DataType.INT32));
            this.transformedDataType.add(DataCollectionDisplayInfo.getDataTypeName((DataType)DataType.UINT32));
            this.transformedDataType.add(DataCollectionDisplayInfo.getDataTypeName((DataType)DataType.COUNTER32));
            this.transformedDataType.add(DataCollectionDisplayInfo.getDataTypeName((DataType)DataType.INT64));
            this.transformedDataType.add(DataCollectionDisplayInfo.getDataTypeName((DataType)DataType.UINT64));
            this.transformedDataType.add(DataCollectionDisplayInfo.getDataTypeName((DataType)DataType.COUNTER64));
            this.transformedDataType.add(DataCollectionDisplayInfo.getDataTypeName((DataType)DataType.FLOAT));
            this.transformedDataType.add(DataCollectionDisplayInfo.getDataTypeName((DataType)DataType.STRING));
            this.transformedDataType.select(Transformation.getDataTypePosition(this.editor.getObjectAsItem().getTransformedDataType()));
            this.deltaCalculation = new LabeledCombo(dialogArea, 0);
            Messages.get();
            this.deltaCalculation.setLabel(Messages.Transformation_Step1);
            this.deltaCalculation.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            Messages.get();
            this.deltaCalculation.add(Messages.Transformation_DeltaNone);
            Messages.get();
            this.deltaCalculation.add(Messages.Transformation_DeltaSimple);
            Messages.get();
            this.deltaCalculation.add(Messages.Transformation_DeltaAvgPerSec);
            Messages.get();
            this.deltaCalculation.add(Messages.Transformation_DeltaAvgPerMin);
            this.deltaCalculation.select(this.editor.getObjectAsItem().getDeltaCalculation());
        }
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.widthHint = 0;
        gd.heightHint = 0;
        WidgetFactory factory = new WidgetFactory(){

            public Control createControl(Composite parent, int style) {
                return new ScriptEditor(parent, style, 768, true, "Variables:\r\n\t$1\t\t\tvalue to transform (after delta calculation);\r\n\t$dci\t\t\tthis DCI object;\r\n\t$isCluster\ttrue if DCI is on cluster;\r\n\t$node\t\tcurrent node object (null if DCI is not on the node);\r\n\t$object\t\tcurrent object.\r\n\r\nReturn value: transformed DCI value or null to keep original value.");
            }
        };
        if (this.editor.getObject() instanceof DataCollectionItem) {
            Messages.get();
            string = Messages.Transformation_Step2;
        } else {
            Messages.get();
            string = Messages.Transformation_Script;
        }
        this.transformationScript = (ScriptEditor)WidgetHelper.createLabeledControl((Composite)dialogArea, (int)2048, (WidgetFactory)factory, (String)string, (Object)gd);
        this.transformationScript.addFunctions(Arrays.asList(DCI_FUNCTIONS));
        this.transformationScript.addVariables(Arrays.asList(DCI_VARIABLES));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.transformationScript.setLayoutData((Object)gd);
        this.transformationScript.setText(this.editor.getObject().getTransformationScript());
        if (this.editor.getObject() instanceof DataCollectionItem) {
            this.testScriptButton = new Button(this.transformationScript.getParent(), 8);
            Messages.get();
            this.testScriptButton.setText(Messages.Transformation_Test);
            gd = new GridData();
            gd.horizontalAlignment = 131072;
            gd.widthHint = 90;
            this.testScriptButton.setLayoutData((Object)gd);
            this.testScriptButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TestTransformationDlg dlg = new TestTransformationDlg(Transformation.this.getShell(), Transformation.this.editor.getObject(), Transformation.this.transformationScript.getText());
                    dlg.open();
                }
            });
        }
        return dialogArea;
    }

    protected void applyChanges(boolean isApply) {
        if (this.editor.getObject() instanceof DataCollectionItem) {
            this.editor.getObjectAsItem().setDeltaCalculation(this.deltaCalculation.getSelectionIndex());
            this.editor.getObjectAsItem().setTransformedDataType(Transformation.getDataTypeByPosition(this.transformedDataType.getSelectionIndex()));
        }
        this.editor.getObject().setTransformationScript(this.transformationScript.getText());
        this.editor.modify();
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    protected void performDefaults() {
        super.performDefaults();
        if (this.deltaCalculation != null) {
            this.deltaCalculation.select(0);
        }
        this.transformationScript.setText("");
    }

    private static int getDataTypePosition(DataType type) {
        switch (type) {
            case COUNTER32: {
                return 3;
            }
            case COUNTER64: {
                return 4;
            }
            case FLOAT: {
                return 7;
            }
            case INT32: {
                return 1;
            }
            case INT64: {
                return 4;
            }
            case STRING: {
                return 8;
            }
            case UINT32: {
                return 2;
            }
            case UINT64: {
                return 5;
            }
        }
        return 0;
    }

    private static DataType getDataTypeByPosition(int position) {
        return TYPES[position];
    }
}

