/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.widgets;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.datacollection.Activator;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.dialogs.LogMacroEditDialog;
import org.netxms.ui.eclipse.datacollection.widgets.helpers.LogParser;
import org.netxms.ui.eclipse.datacollection.widgets.helpers.LogParserFile;
import org.netxms.ui.eclipse.datacollection.widgets.helpers.LogParserFileEditor;
import org.netxms.ui.eclipse.datacollection.widgets.helpers.LogParserModifyListener;
import org.netxms.ui.eclipse.datacollection.widgets.helpers.LogParserRule;
import org.netxms.ui.eclipse.datacollection.widgets.helpers.LogParserRuleEditor;
import org.netxms.ui.eclipse.datacollection.widgets.helpers.LogParserType;
import org.netxms.ui.eclipse.datacollection.widgets.helpers.MacroListLabelProvider;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;
import org.netxms.ui.eclipse.widgets.Section;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;
import org.netxms.ui.eclipse.widgets.TextEditor;
import org.netxms.ui.eclipse.widgets.helpers.ExpansionEvent;
import org.netxms.ui.eclipse.widgets.helpers.ExpansionListener;

public class LogParserEditor
extends Composite
implements IFindReplaceTarget {
    private static final int TAB_NONE = 0;
    private static final int TAB_BUILDER = 1;
    private static final int TAB_XML = 2;
    private static final int DEFAULT_FILE_CHECK_INTERVAL = 10000;
    private CTabFolder tabFolder;
    private int currentTab = 0;
    private TextEditor xmlEditor;
    private Set<LogParserModifyListener> listeners = new HashSet<LogParserModifyListener>();
    private boolean enableModifyListeners = true;
    private LogParser parser = new LogParser();
    private ScrolledComposite scroller;
    private Composite visualEditorArea;
    private Composite rulesArea;
    private Composite fileArea;
    private ImageHyperlink addRuleLink;
    private ImageHyperlink addFileLink;
    private SortableTableViewer macroList;
    private LogParserType type;
    private FindReplaceAction actionFindReplace = null;
    private LabeledText textName;
    private Spinner spinnerFileCheckInterval;
    private Button checkProcessAll;

    public LogParserEditor(Composite parent, int style, LogParserType type) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.type = type;
        this.tabFolder = new CTabFolder((Composite)this, 8389634);
        this.tabFolder.setUnselectedImageVisible(true);
        this.tabFolder.setSelectionBarThickness(0);
        this.tabFolder.setSimple(true);
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String xml = switch (LogParserEditor.this.currentTab) {
                    case 1 -> LogParserEditor.this.parser != null ? LogParserEditor.this.buildParserXml() : "";
                    case 2 -> LogParserEditor.this.xmlEditor.getText();
                    default -> null;
                };
                CTabItem tab = LogParserEditor.this.tabFolder.getSelection();
                int n = LogParserEditor.this.currentTab = tab != null ? (Integer)tab.getData() : 0;
                if (xml != null) {
                    switch (LogParserEditor.this.currentTab) {
                        case 1: {
                            LogParserEditor.this.updateBuilderFromXml(LogParserEditor.this.xmlEditor.getText());
                            break;
                        }
                        case 2: {
                            if (LogParserEditor.this.parser == null) break;
                            LogParserEditor.this.xmlEditor.setText(LogParserEditor.this.buildParserXml());
                            break;
                        }
                    }
                }
                if (LogParserEditor.this.actionFindReplace != null) {
                    LogParserEditor.this.actionFindReplace.setEnabled(LogParserEditor.this.currentTab == 2);
                }
            }
        });
        this.createVisualEditor();
        this.createTextEditor();
    }

    private void selectXmlEditor() {
        CTabItem tab = this.tabFolder.getSelection();
        if (tab != null && (Integer)tab.getData() == 2) {
            return;
        }
        CTabItem[] cTabItemArray = this.tabFolder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem t = cTabItemArray[n2];
            if ((Integer)t.getData() == 2) {
                this.tabFolder.setSelection(t);
                this.currentTab = 2;
                break;
            }
            ++n2;
        }
    }

    private void createVisualEditor() {
        this.scroller = new ScrolledComposite((Composite)this.tabFolder, 512);
        this.scroller.setExpandHorizontal(true);
        this.scroller.setExpandVertical(true);
        WidgetHelper.setScrollBarIncrement((Scrollable)this.scroller, (int)512, (int)20);
        this.scroller.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                LogParserEditor.this.updateScroller();
            }
        });
        CTabItem tabItem = new CTabItem(this.tabFolder, 0);
        Messages.get();
        tabItem.setText(Messages.LogParserEditor_Editor);
        tabItem.setImage(SharedIcons.IMG_EDIT);
        tabItem.setControl((Control)this.scroller);
        tabItem.setData((Object)1);
        this.visualEditorArea = new Composite((Composite)this.scroller, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.horizontalSpacing = 8;
        layout.verticalSpacing = 8;
        layout.marginWidth = 8;
        layout.marginHeight = 8;
        this.visualEditorArea.setLayout((Layout)layout);
        this.visualEditorArea.setBackground(this.getDisplay().getSystemColor(25));
        this.scroller.setContent((Control)this.visualEditorArea);
        Section section = new Section(this.visualEditorArea, "General", true);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.widthHint = 400;
        section.setLayoutData((Object)gd);
        section.addExpansionListener(new ExpansionListener(){

            public void expansionStateChanged(ExpansionEvent e) {
                ((GridData)((Control)e.widget).getLayoutData()).verticalAlignment = e.getState() ? 4 : 128;
            }
        });
        this.createGeneralArea(section.getClient());
        Messages.get();
        section = new Section(this.visualEditorArea, Messages.LogParserEditor_Macros, true);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        section.setLayoutData((Object)gd);
        section.addExpansionListener(new ExpansionListener(){

            public void expansionStateChanged(ExpansionEvent e) {
                ((GridData)((Control)e.widget).getLayoutData()).verticalAlignment = e.getState() ? 4 : 128;
            }
        });
        this.createMacroSection(section.getClient());
        Messages.get();
        section = new Section(this.visualEditorArea, Messages.LogParserEditor_Rules, true);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        section.setLayoutData((Object)gd);
        this.rulesArea = section.getClient();
        GridLayout rulesAreaLayout = new GridLayout();
        rulesAreaLayout.marginHeight = 0;
        rulesAreaLayout.marginWidth = 0;
        rulesAreaLayout.verticalSpacing = 1;
        this.rulesArea.setLayout((Layout)rulesAreaLayout);
        this.rulesArea.setBackground(this.visualEditorArea.getBackground());
        this.addRuleLink = new ImageHyperlink(this.rulesArea, 0);
        Messages.get();
        this.addRuleLink.setText(Messages.LogParserEditor_AddRule);
        this.addRuleLink.setImage(SharedIcons.IMG_ADD_OBJECT);
        this.addRuleLink.setBackground(this.rulesArea.getBackground());
        this.addRuleLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                LogParserEditor.this.addRule();
            }
        });
    }

    public void updateScroller() {
        this.visualEditorArea.layout(true, true);
        this.scroller.setMinSize(this.visualEditorArea.computeSize(this.scroller.getSize().x, -1));
    }

    private void createGeneralArea(Composite generalArea) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        generalArea.setLayout((Layout)layout);
        this.textName = new LabeledText(generalArea, 0);
        this.textName.setLabel("Parser name");
        this.textName.setText(this.parser.getName() != null ? this.parser.getName() : "");
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = this.type == LogParserType.POLICY ? 1 : 2;
        gd.verticalAlignment = 1024;
        this.textName.setLayoutData((Object)gd);
        this.textName.getTextControl().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LogParserEditor.this.fireModifyListeners();
            }
        });
        if (this.type == LogParserType.POLICY) {
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1024;
            this.spinnerFileCheckInterval = WidgetHelper.createLabeledSpinner((Composite)generalArea, (int)2048, (String)"File check interval", (int)1000, (int)60000, (Object)gd);
            this.spinnerFileCheckInterval.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    LogParserEditor.this.fireModifyListeners();
                }
            });
            this.spinnerFileCheckInterval.setSelection(this.parser.getFileCheckInterval() != null ? this.parser.getFileCheckInterval() : 10000);
        }
        this.checkProcessAll = new Button(generalArea, 32);
        this.checkProcessAll.setText("Always process all rules");
        this.checkProcessAll.setSelection(this.parser.getProcessALL());
        this.checkProcessAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogParserEditor.this.fireModifyListeners();
            }
        });
        if (this.type == LogParserType.POLICY) {
            this.fileArea = new Composite(generalArea, 0);
            layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.fileArea.setLayout((Layout)layout);
            gd = new GridData();
            gd.horizontalSpan = 3;
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.fileArea.setLayoutData((Object)gd);
            this.addFileLink = new ImageHyperlink(this.fileArea, 0);
            this.addFileLink.setText("Add file");
            this.addFileLink.setImage(SharedIcons.IMG_ADD_OBJECT);
            this.addFileLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    LogParserEditor.this.addFile();
                }
            });
        }
    }

    private void createTextEditor() {
        this.xmlEditor = new TextEditor((Composite)this.tabFolder, 0, 770);
        this.xmlEditor.getTextControl().setFont(JFaceResources.getTextFont());
        CTabItem tabItem = new CTabItem(this.tabFolder, 0);
        Messages.get();
        tabItem.setText(Messages.LogParserEditor_XML);
        tabItem.setImage(SharedIcons.IMG_XML);
        tabItem.setControl((Control)this.xmlEditor);
        tabItem.setData((Object)2);
        this.xmlEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LogParserEditor.this.fireModifyListeners();
            }
        });
    }

    private void createMacroSection(Composite macroArea) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        macroArea.setLayout((Layout)layout);
        String[] stringArray = new String[2];
        Messages.get();
        stringArray[0] = Messages.LogParserEditor_Name;
        Messages.get();
        stringArray[1] = Messages.LogParserEditor_Value;
        String[] columnNames = stringArray;
        int[] columnWidths = new int[]{100, 200};
        this.macroList = new SortableTableViewer(macroArea, columnNames, columnWidths, 0, 128, 2048);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.verticalSpan = 3;
        gd.heightHint = 200;
        Table table = this.macroList.getTable();
        table.setLayoutData((Object)gd);
        this.macroList.setLabelProvider((IBaseLabelProvider)new MacroListLabelProvider());
        this.macroList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.macroList.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                Map.Entry d1 = (Map.Entry)e1;
                Map.Entry d2 = (Map.Entry)e2;
                int result = switch ((Integer)((SortableTableViewer)viewer).getTable().getSortColumn().getData("ID")) {
                    case 0 -> ((String)d1.getKey()).compareTo((String)d2.getKey());
                    case 1 -> ((String)d1.getValue()).compareTo((String)d2.getValue());
                    default -> 0;
                };
                return ((SortableTableViewer)viewer).getTable().getSortDirection() == 128 ? result : -result;
            }
        });
        ImageHyperlink link = new ImageHyperlink(macroArea, 0);
        link.setImage(SharedIcons.IMG_ADD_OBJECT);
        Messages.get();
        link.setText(Messages.LogParserEditor_Add);
        link.setBackground(macroArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        link.setLayoutData((Object)gd);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                LogParserEditor.this.addMacro();
            }
        });
        link = new ImageHyperlink(macroArea, 0);
        link.setImage(SharedIcons.IMG_EDIT);
        Messages.get();
        link.setText(Messages.LogParserEditor_Edit);
        link.setBackground(macroArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        link.setLayoutData((Object)gd);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                LogParserEditor.this.editMacro();
            }
        });
        link = new ImageHyperlink(macroArea, 0);
        link.setImage(SharedIcons.IMG_DELETE_OBJECT);
        Messages.get();
        link.setText(Messages.LogParserEditor_Delete);
        link.setBackground(macroArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        link.setLayoutData((Object)gd);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                LogParserEditor.this.deleteMacro();
            }
        });
    }

    public void addModifyListener(LogParserModifyListener modifyListener) {
        this.listeners.add(modifyListener);
    }

    public void removeModifyListener(LogParserModifyListener modifyListener) {
        this.listeners.remove(modifyListener);
    }

    public void fireModifyListeners() {
        if (this.enableModifyListeners) {
            for (LogParserModifyListener l : this.listeners) {
                l.modifyParser();
            }
        }
    }

    public String getParserXml() {
        switch (this.currentTab) {
            case 1: {
                return this.buildParserXml();
            }
            case 2: {
                return this.xmlEditor.getText();
            }
        }
        return "<parser></parser>";
    }

    private String buildParserXml() {
        if (this.type == LogParserType.POLICY) {
            for (LogParserFile file : this.parser.getFiles()) {
                file.getEditor().save();
            }
            this.parser.setFileCheckInterval(this.spinnerFileCheckInterval.getSelection());
        }
        this.parser.setName(this.textName.getText());
        this.parser.setProcessALL(this.checkProcessAll.getSelection());
        for (LogParserRule rule : this.parser.getRules()) {
            rule.getEditor().save();
        }
        try {
            return this.parser.createXml();
        }
        catch (Exception e) {
            Activator.logError("Unexpected error creating parser XML", e);
            return "<parser>\n</parser>";
        }
    }

    public void setParserXml(String xml) {
        this.enableModifyListeners = false;
        this.xmlEditor.setText(xml);
        this.updateBuilderFromXml(xml);
        this.enableModifyListeners = true;
    }

    private void updateBuilderFromXml(String xml) {
        if (this.parser != null) {
            for (LogParserFile file : this.parser.getFiles()) {
                file.getEditor().dispose();
            }
            for (LogParserRule rule : this.parser.getRules()) {
                rule.getEditor().dispose();
            }
        }
        try {
            this.parser = LogParser.createFromXml(xml);
        }
        catch (Exception e) {
            Activator.logError("Error creating log parser object from XML", e);
            Shell shell = this.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.LogParserEditor_Error, (String)Messages.LogParserEditor_InvalidDefinition);
            this.parser = null;
            this.selectXmlEditor();
            return;
        }
        this.parser.setSyslogParser(this.type);
        if (this.type == LogParserType.POLICY) {
            for (LogParserFile file : this.parser.getFiles()) {
                this.createFileEditor(file).moveAbove((Control)this.addFileLink);
            }
            this.spinnerFileCheckInterval.setSelection(this.parser.getFileCheckInterval() != null ? this.parser.getFileCheckInterval() : 10000);
        }
        this.textName.setText(this.parser.getName());
        this.checkProcessAll.setSelection(this.parser.getProcessALL());
        for (LogParserRule rule : this.parser.getRules()) {
            this.createRuleEditor(rule).moveAbove((Control)this.addRuleLink);
        }
        this.macroList.setInput((Object)this.parser.getMacros().entrySet().toArray());
        this.updateScroller();
    }

    private LogParserRuleEditor createRuleEditor(LogParserRule rule) {
        LogParserRuleEditor editor = new LogParserRuleEditor(this.rulesArea, rule, this);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        editor.setLayoutData(gd);
        rule.setEditor(editor);
        return editor;
    }

    private void addRule() {
        LogParserRule rule = new LogParserRule();
        LogParserRuleEditor editor = this.createRuleEditor(rule);
        editor.moveAbove((Control)this.addRuleLink);
        this.parser.getRules().add(rule);
        this.updateScroller();
        this.fireModifyListeners();
    }

    private LogParserFileEditor createFileEditor(LogParserFile file) {
        LogParserFileEditor editor = new LogParserFileEditor(this.fileArea, file, this);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        editor.setLayoutData(gd);
        file.setEditor(editor);
        return editor;
    }

    private void addFile() {
        LogParserFile file = new LogParserFile();
        LogParserFileEditor editor = this.createFileEditor(file);
        editor.moveAbove((Control)this.addFileLink);
        this.parser.getFiles().add(file);
        this.updateScroller();
        this.fireModifyListeners();
    }

    private void addMacro() {
        LogMacroEditDialog dlg = new LogMacroEditDialog(this.getShell(), null, null);
        if (dlg.open() == 0) {
            this.parser.getMacros().put(dlg.getName(), dlg.getValue());
            this.macroList.setInput((Object)this.parser.getMacros().entrySet().toArray());
            this.fireModifyListeners();
        }
    }

    private void editMacro() {
        IStructuredSelection selection = (IStructuredSelection)this.macroList.getSelection();
        if (selection.size() != 1) {
            return;
        }
        Map.Entry e = (Map.Entry)selection.getFirstElement();
        LogMacroEditDialog dlg = new LogMacroEditDialog(this.getShell(), (String)e.getKey(), (String)e.getValue());
        if (dlg.open() == 0) {
            this.parser.getMacros().put(dlg.getName(), dlg.getValue());
            this.macroList.setInput((Object)this.parser.getMacros().entrySet().toArray());
            this.fireModifyListeners();
        }
    }

    private void deleteMacro() {
        IStructuredSelection selection = (IStructuredSelection)this.macroList.getSelection();
        if (selection.size() == 0) {
            return;
        }
        Map<String, String> macros = this.parser.getMacros();
        for (Object o : selection.toList()) {
            macros.remove(((Map.Entry)o).getKey());
        }
        this.macroList.setInput((Object)macros.entrySet().toArray());
        this.fireModifyListeners();
    }

    public void deleteRule(LogParserRule rule) {
        this.parser.getRules().remove(rule);
        rule.getEditor().dispose();
        this.updateScroller();
        this.getParent().layout(true, true);
        this.fireModifyListeners();
    }

    public void deleteFile(LogParserFile file) {
        this.parser.getFiles().remove(file);
        file.getEditor().dispose();
        this.updateScroller();
        this.getParent().layout(true, true);
        this.fireModifyListeners();
    }

    public void moveRuleUp(LogParserRule rule) {
        int index = this.parser.getRules().indexOf(rule);
        if (index < 1) {
            return;
        }
        rule.getEditor().moveAbove((Control)this.parser.getRules().get(index - 1).getEditor());
        Collections.swap(this.parser.getRules(), index - 1, index);
        this.updateScroller();
        this.getParent().layout(true, true);
        this.fireModifyListeners();
    }

    public void moveRuleDown(LogParserRule rule) {
        int index = this.parser.getRules().indexOf(rule);
        if (index < 0 || index >= this.parser.getRules().size() - 1) {
            return;
        }
        rule.getEditor().moveBelow((Control)this.parser.getRules().get(index + 1).getEditor());
        Collections.swap(this.parser.getRules(), index + 1, index);
        this.updateScroller();
        this.getParent().layout(true, true);
        this.fireModifyListeners();
    }

    public LogParserType getParserType() {
        return this.type;
    }

    public boolean isWindowsEventLogParser() {
        boolean isWindowsEventLogParser = false;
        for (LogParserFile file : this.parser.getFiles()) {
            if (!file.getEditor().getFile().startsWith("*")) continue;
            isWindowsEventLogParser = true;
            break;
        }
        return isWindowsEventLogParser;
    }

    public void updateRules() {
        for (LogParserRule rule : this.parser.getRules()) {
            if (rule.getEditor() == null) continue;
            rule.getEditor().updateWindowsEventLogFields();
        }
    }

    public void setFindAndReplaceAction(FindReplaceAction actionFindReplace) {
        this.actionFindReplace = actionFindReplace;
    }

    public boolean isEditorTabSelected() {
        return this.currentTab == 2;
    }

    public boolean canPerformFind() {
        return this.isEditorTabSelected();
    }

    public int findAndSelect(int widgetOffset, String findString, boolean searchForward, boolean caseSensitive, boolean wholeWord) {
        if (!this.isEditorTabSelected()) {
            return -1;
        }
        return this.xmlEditor.findAndSelect(widgetOffset, findString, searchForward, caseSensitive, wholeWord);
    }

    public Point getSelection() {
        return this.xmlEditor.getSelection();
    }

    public String getSelectionText() {
        return this.xmlEditor.getSelectionText();
    }

    public boolean isEditable() {
        return this.isEditorTabSelected();
    }

    public void replaceSelection(String text) {
        if (this.isEditorTabSelected()) {
            this.xmlEditor.replaceSelection(text);
        }
    }
}

