/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.perfview.widgets.helpers;

import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.netxms.ui.eclipse.perfview.widgets.helpers.CellSelectionManager;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class CellSelectionHighlighter {
    private SortableTableViewer viewer;
    private CellSelectionManager manager;

    public CellSelectionHighlighter(SortableTableViewer viewer, CellSelectionManager manager) {
        this.viewer = viewer;
        this.manager = manager;
        viewer.getControl().addListener(42, new Listener(){

            public void handleEvent(Event event) {
                ViewerCell focusCell = CellSelectionHighlighter.this.getFocusCell();
                ViewerRow row = CellSelectionHighlighter.this.viewer.getViewerRowFromItem(event.item);
                ViewerCell cell = row.getCell(event.index);
                if (cell.equals((Object)focusCell)) {
                    CellSelectionHighlighter.this.markFocusedCell(event, cell);
                }
                event.gc.setForeground(cell.getControl().getDisplay().getSystemColor(CellSelectionHighlighter.this.manager.isCellSelected(cell) ? 27 : 24));
                event.detail &= 0xFFFFFFFB;
            }
        });
        viewer.getControl().addListener(40, new Listener(){

            public void handleEvent(Event event) {
                ViewerRow row = CellSelectionHighlighter.this.viewer.getViewerRowFromItem(event.item);
                ViewerCell cell = row.getCell(event.index);
                CellSelectionHighlighter.this.drawCellBackground(event, cell, CellSelectionHighlighter.this.manager.isCellSelected(cell));
                event.detail &= 0xFFFFFFD9;
            }
        });
        viewer.getControl().addListener(41, new Listener(){

            public void handleEvent(Event event) {
            }
        });
    }

    private void drawCellBackground(Event event, ViewerCell cell, boolean selected) {
        GC gc = event.gc;
        Display display = cell.getControl().getDisplay();
        gc.setBackground(display.getSystemColor(selected ? 26 : 25));
        gc.setForeground(display.getSystemColor(selected ? 27 : 24));
        gc.fillRectangle(cell.getBounds());
    }

    private void markFocusedCell(Event event, ViewerCell cell) {
        GC gc = event.gc;
        Rectangle r = cell.getBounds();
        gc.drawFocus(r.x, r.y, r.width, r.height);
    }

    private ViewerCell getFocusCell() {
        if (this.manager != null) {
            return this.manager.getFocusCell();
        }
        return this.viewer.getColumnViewerEditor().getFocusCell();
    }

    protected void focusCellChanged(ViewerCell newCell, ViewerCell oldCell) {
        int width;
        int x;
        Rectangle rect;
        if (newCell != null) {
            rect = newCell.getBounds();
            x = newCell.getColumnIndex() == 0 ? 0 : rect.x;
            width = newCell.getColumnIndex() == 0 ? rect.x + rect.width : rect.width;
            newCell.getControl().redraw(x, rect.y - 1, width, rect.height + 1, true);
        }
        if (oldCell != null) {
            rect = oldCell.getBounds();
            x = oldCell.getColumnIndex() == 0 ? 0 : rect.x;
            width = oldCell.getColumnIndex() == 0 ? rect.x + rect.width : rect.width;
            oldCell.getControl().redraw(x, rect.y - 1, width, rect.height + 1, true);
        }
    }
}

