/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.layout;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.nxmc.base.layout.DashboardLayoutData;

/*
 * Exception performing whole class analysis ignored.
 */
public class DashboardLayout
extends Layout {
    public int numColumns = 1;
    public int marginWidth = 0;
    public int marginHeight = 0;
    public int horizontalSpacing = 5;
    public int verticalSpacing = 5;
    public boolean scrollable = false;
    private static final int MAX_ROWS = 64;
    private int rowCount = 0;
    private Map<Control, Point> coordinates = new HashMap(0);
    private int[] rowStart = null;
    private Point cachedSize = null;

    private int freeSpaceInRow(boolean[][] cellUsed, int row) {
        int i;
        for (i = this.numColumns - 1; i >= 0 && !cellUsed[row][i]; --i) {
        }
        return this.numColumns - i - 1;
    }

    private void createGrid(Composite parent) {
        Control[] children = parent.getChildren();
        this.coordinates = new HashMap(children.length);
        boolean[][] cellUsed = new boolean[64][this.numColumns];
        int currentColumn = 0;
        int currentRow = 0;
        this.rowCount = 0;
        for (Control child : children) {
            if (!child.isVisible()) continue;
            DashboardLayoutData layoutData = DashboardLayout.getLayoutData((Control)child);
            int columnSpan = layoutData.horizontalSpan;
            if (columnSpan > this.numColumns) {
                throw new IllegalArgumentException("colSpan (" + columnSpan + ") > number of columns (" + this.numColumns + ")");
            }
            int freeSpace = 0;
            for (int j = currentColumn; j < this.numColumns && freeSpace < columnSpan; ++j) {
                if (!cellUsed[currentRow][j]) {
                    ++freeSpace;
                    continue;
                }
                freeSpace = 0;
                currentColumn = j + 1;
                if (currentColumn != this.numColumns) continue;
                currentColumn = 0;
                ++currentRow;
                j = -1;
            }
            if (freeSpace < columnSpan) {
                while (this.freeSpaceInRow(cellUsed, currentRow) < layoutData.horizontalSpan) {
                    ++currentRow;
                }
                currentColumn = 0;
            }
            for (int _c = 0; _c < columnSpan; ++_c) {
                for (int _r = 0; _r < layoutData.verticalSpan; ++_r) {
                    cellUsed[currentRow + _r][currentColumn + _c] = true;
                }
            }
            this.coordinates.put(child, new Point(currentColumn, currentRow));
            this.rowCount = Math.max(currentRow + layoutData.verticalSpan, this.rowCount);
            if ((currentColumn += columnSpan) != this.numColumns) continue;
            currentColumn = 0;
            ++currentRow;
        }
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        if (wHint != -1 && hHint != -1) {
            return new Point(wHint, hHint);
        }
        if (this.cachedSize != null && !flushCache) {
            return new Point(this.cachedSize.x, this.cachedSize.y);
        }
        this.createGrid(composite);
        if (this.rowCount == 0) {
            return new Point(0, 0);
        }
        int widthHint = wHint != -1 ? wHint / this.numColumns : -1;
        int[] rowSizeX = new int[this.rowCount];
        int[] rowSizeY = new int[this.rowCount];
        for (Map.Entry e : this.coordinates.entrySet()) {
            DashboardLayoutData layoutData = DashboardLayout.getLayoutData((Control)((Control)e.getKey()));
            Point s = ((Control)e.getKey()).computeSize(widthHint != -1 ? widthHint * layoutData.horizontalSpan : -1, -1, flushCache);
            int n = ((Point)e.getValue()).y;
            rowSizeX[n] = rowSizeX[n] + s.x;
            int h = layoutData.heightHint > 0 && (this.scrollable || !layoutData.fill) ? layoutData.heightHint : s.y;
            if (rowSizeY[((Point)e.getValue()).y] >= h / layoutData.verticalSpan) continue;
            rowSizeY[((Point)e.getValue()).y] = h / layoutData.verticalSpan;
        }
        Point size = new Point(0, (this.rowCount - 1) * this.verticalSpacing + this.marginHeight * 2);
        for (int i = 0; i < this.rowCount; ++i) {
            int w = rowSizeX[i] + this.marginWidth * 2 + (this.numColumns - 1) * this.horizontalSpacing;
            if (size.x < w) {
                size.x = w;
            }
            size.y += rowSizeY[i];
        }
        this.cachedSize = new Point(size.x, size.y);
        return size;
    }

    protected void layout(Composite composite, boolean flushCache) {
        int i;
        DashboardLayoutData layoutData;
        this.createGrid(composite);
        if (this.rowCount == 0) {
            return;
        }
        Point size = composite.getSize();
        int height = size.y - this.marginHeight * 2;
        int columnWidth = (size.x - this.marginWidth * 2 - this.horizontalSpacing * (this.numColumns - 1)) / this.numColumns;
        float[] rowSize = new float[this.rowCount];
        Arrays.fill(rowSize, 0.0f);
        int[] rowFill = new int[this.rowCount];
        Arrays.fill(rowFill, 0);
        for (Map.Entry e : this.coordinates.entrySet()) {
            layoutData = DashboardLayout.getLayoutData((Control)((Control)e.getKey()));
            if (layoutData.fill && !this.scrollable) {
                if (layoutData.verticalSpan > 1) {
                    for (int i2 = 0; i2 < layoutData.verticalSpan; ++i2) {
                        int r = ((Point)e.getValue()).y + i2;
                        if (rowFill[r] != 0) continue;
                        rowFill[r] = 2;
                    }
                    continue;
                }
                rowFill[((Point)e.getValue()).y] = 3;
                continue;
            }
            int ch = layoutData.heightHint > 0 ? layoutData.heightHint : ((Control)e.getKey()).computeSize((int)columnWidth, (int)-1, (boolean)flushCache).y;
            int rs = (ch - (layoutData.verticalSpan - 1) * this.verticalSpacing) / layoutData.verticalSpan;
            for (int i3 = 0; i3 < layoutData.verticalSpan; ++i3) {
                int r = ((Point)e.getValue()).y + i3;
                if (rowSize[r] < (float)rs) {
                    rowSize[r] = rs;
                }
                if (rowFill[r] >= 3) continue;
                rowFill[r] = 1;
            }
        }
        if (!this.scrollable) {
            for (Map.Entry e : this.coordinates.entrySet()) {
                layoutData = DashboardLayout.getLayoutData((Control)((Control)e.getKey()));
                if (!layoutData.fill || layoutData.verticalSpan <= 1) continue;
                boolean ok = false;
                for (i = 0; i < layoutData.verticalSpan; ++i) {
                    int r = ((Point)e.getValue()).y + i;
                    if (rowFill[r] < 2) continue;
                    rowFill[r] = 3;
                    ok = true;
                }
                if (ok) continue;
                rowFill[((Point)e.getValue()).y] = 3;
            }
        }
        float usedSpace = 0.0f;
        int fillRows = 0;
        for (int i4 = 0; i4 < this.rowCount; ++i4) {
            if (rowFill[i4] == 3) {
                ++fillRows;
            }
            usedSpace += rowSize[i4];
        }
        if (usedSpace > (float)(height - this.verticalSpacing * (this.rowCount - 1))) {
            float extraSpace = usedSpace - (float)height;
            float maxRowSize = (float)(height - this.verticalSpacing * (this.rowCount - 1)) / (float)this.rowCount;
            for (i = 0; i < this.rowCount; ++i) {
                if (!(rowSize[i] > maxRowSize)) continue;
                float delta = Math.min(rowSize[i] - maxRowSize, extraSpace);
                int n = i;
                rowSize[n] = rowSize[n] - delta;
                extraSpace -= delta;
                usedSpace -= delta;
            }
        }
        if (fillRows > 0) {
            float extraHeight = ((float)height - usedSpace - (float)(this.verticalSpacing * (this.rowCount - 1))) / (float)fillRows;
            for (int i5 = 0; i5 < this.rowCount; ++i5) {
                if (rowFill[i5] != 3) continue;
                int n = i5;
                rowSize[n] = rowSize[n] + extraHeight;
            }
        }
        this.rowStart = new int[this.rowCount];
        this.rowStart[0] = this.marginHeight;
        for (int i6 = 1; i6 < this.rowCount; ++i6) {
            this.rowStart[i6] = Math.round((float)this.rowStart[i6 - 1] + rowSize[i6 - 1]) + this.verticalSpacing;
        }
        for (Control c : composite.getChildren()) {
            Point p;
            if (!c.isVisible() || (p = (Point)this.coordinates.get(c)) == null) continue;
            DashboardLayoutData layoutData2 = DashboardLayout.getLayoutData((Control)c);
            int cw = layoutData2.horizontalSpan * columnWidth + (layoutData2.horizontalSpan - 1) * this.horizontalSpacing;
            float ch = rowSize[p.y];
            for (int j = 1; j < layoutData2.verticalSpan; ++j) {
                ch += rowSize[p.y + j] + (float)this.verticalSpacing;
            }
            c.setSize(cw, Math.round(ch));
            c.setLocation(p.x * (columnWidth + this.horizontalSpacing) + this.marginWidth, this.rowStart[p.y]);
        }
    }

    private static DashboardLayoutData getLayoutData(Control c) {
        Object data = c.getLayoutData();
        return data != null && data instanceof DashboardLayoutData ? (DashboardLayoutData)data : DashboardLayoutData.DEFAULT;
    }
}

