/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.widgets;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.netxms.nxmc.base.widgets.CommandTextBox;
import org.netxms.nxmc.resources.SharedIcons;

public class CommandTextBox
extends Composite
implements DisposeListener {
    private List<CommandEntry> actions = new ArrayList();
    private Map<ImageDescriptor, Image> imageCache = new HashMap();
    private Cursor cursor;

    public CommandTextBox(Composite parent, int style) {
        super(parent, style);
        this.setBackground(this.getDisplay().getSystemColor(25));
        this.cursor = new Cursor((Device)this.getDisplay(), 21);
        RowLayout layout = new RowLayout();
        layout.type = 512;
        this.setLayout((Layout)layout);
        this.addDisposeListener((DisposeListener)this);
    }

    public void rebuild() {
        for (CommandEntry entry : this.actions) {
            entry.textLabel = new Text((Composite)this, 16384);
            entry.textLabel.setText(entry.text);
            entry.textLabel.setForeground(this.getDisplay().getSystemColor(24));
            entry.textLabel.setBackground(this.getDisplay().getSystemColor(25));
            CLabel label = new CLabel((Composite)this, 16384);
            label.setText(entry.action.getText());
            label.setImage(this.getImage(entry.action));
            label.setCursor(this.cursor);
            label.setForeground(this.getDisplay().getSystemColor(24));
            label.setBackground(this.getDisplay().getSystemColor(25));
            label.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.layout();
    }

    private Image getImage(Action action) {
        Image img;
        ImageDescriptor d = action.getImageDescriptor();
        if (d != null) {
            img = (Image)this.imageCache.get(d);
            if (img == null) {
                img = d.createImage();
                this.imageCache.put(d, img);
            }
        } else {
            img = SharedIcons.IMG_EMPTY;
        }
        return img;
    }

    public void addOrUpdate(Action action, String text, boolean doRebuild) {
        boolean found = false;
        for (CommandEntry entry : this.actions) {
            if (action != entry.action) continue;
            entry.text = text;
            if (entry.textLabel == null) continue;
            entry.textLabel.setText(text);
            found = true;
            if (doRebuild) {
                this.rebuild();
                continue;
            }
            this.layout();
        }
        if (!found) {
            this.actions.add(new CommandEntry(this, action, text));
            if (doRebuild) {
                this.rebuild();
            }
        }
    }

    public void deleteAll(boolean doRebuild) {
        this.actions.clear();
        for (Control c : this.getChildren()) {
            c.dispose();
        }
        if (doRebuild) {
            this.rebuild();
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        for (Image i : this.imageCache.values()) {
            i.dispose();
        }
        this.cursor.dispose();
    }
}

