/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.keyboard;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Display;
import org.netxms.nxmc.keyboard.KeyBindingManager;
import org.netxms.nxmc.keyboard.KeyStroke;

public class KeyBindingManager {
    private Map<KeyStroke, ActionBinding> bindings = new HashMap();

    public void addBinding(KeyStroke keyStroke, IAction action) {
        this.addBinding(keyStroke, action, null);
    }

    public void addBinding(KeyStroke keyStroke, IAction action, String radioGroup) {
        this.bindings.put(keyStroke, new ActionBinding(action, radioGroup));
        String text = action.getText();
        if (text != null && text.indexOf(9) == -1) {
            action.setText(text + "\t" + keyStroke.toString());
        }
    }

    public void addBinding(String definition, IAction action) {
        this.addBinding(definition, action, null);
    }

    public void addBinding(String definition, IAction action, String radioGroup) {
        KeyStroke keyStroke = KeyStroke.parse((String)definition);
        if (keyStroke.isValid()) {
            this.addBinding(keyStroke, action, radioGroup);
        }
    }

    public void addBinding(int modifiers, int key, IAction action) {
        this.addBinding(new KeyStroke(modifiers, key), action, null);
    }

    public void addBinding(int modifiers, int key, IAction action, String radioGroup) {
        this.addBinding(new KeyStroke(modifiers, key), action, radioGroup);
    }

    public void removeBinding(KeyStroke keyStroke) {
        this.bindings.remove(keyStroke);
    }

    public void removeBinding(String definition) {
        this.bindings.remove(KeyStroke.parse((String)definition));
    }

    public void removeBinding(int modifiers, int key) {
        this.bindings.remove(new KeyStroke(modifiers, key));
    }

    public void removeBinding(IAction action) {
        KeyStroke key = null;
        for (Map.Entry e : this.bindings.entrySet()) {
            if (!action.equals(((ActionBinding)e.getValue()).action)) continue;
            key = (KeyStroke)e.getKey();
            break;
        }
        if (key != null) {
            this.bindings.remove(key);
        }
    }

    public boolean processKeyStroke(KeyStroke keyStroke) {
        ActionBinding actionBinding = (ActionBinding)this.bindings.get(keyStroke);
        if (actionBinding == null || !actionBinding.action.isEnabled()) {
            return false;
        }
        Display.getCurrent().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        return true;
    }
}

