/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.keyboard;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.SystemUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class KeyStroke {
    private static final Map<String, Integer> keyCodeLookupTable = new HashMap();
    private static final Map<Integer, String> keyNameLookupTable = new HashMap();
    private int modifiers;
    private int key;

    public static KeyStroke parse(String definition) {
        Integer code;
        int modifiers = 0;
        if (SystemUtils.IS_OS_MAC_OSX) {
            // empty if block
        }
        boolean isMacOS = false;
        String[] parts = definition.split("\\+");
        for (int i = 0; i < parts.length - 1; ++i) {
            String m = parts[i];
            if (m.equalsIgnoreCase("Alt") || m.equalsIgnoreCase("M3") && !isMacOS) {
                modifiers |= 0x10000;
                continue;
            }
            if (m.equalsIgnoreCase("Command") || m.equalsIgnoreCase("M1") && isMacOS) {
                modifiers |= 0x400000;
                continue;
            }
            if (m.equalsIgnoreCase("Ctrl") || m.equalsIgnoreCase("M1") && !isMacOS || m.equalsIgnoreCase("M4") && isMacOS) {
                modifiers |= 0x40000;
                continue;
            }
            if (!m.equalsIgnoreCase("Shift") && !m.equalsIgnoreCase("M2")) continue;
            modifiers |= 0x20000;
        }
        String k = parts[parts.length - 1].toUpperCase();
        int key = k.length() == 1 ? k.charAt(0) : ((code = (Integer)keyCodeLookupTable.get(k)) != null ? code : 0);
        return new KeyStroke(modifiers, key);
    }

    public static String normalizeDefinition(String definition) {
        return KeyStroke.parse((String)definition).toString();
    }

    public KeyStroke(int key) {
        this.modifiers = 0;
        this.key = key;
    }

    public KeyStroke(int modifiers, int key) {
        this.modifiers = modifiers & 0x470000;
        this.key = key >= 97 && key <= 122 ? (int)Character.toUpperCase((char)key) : key;
    }

    public boolean isValid() {
        return this.key != 0;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public int getKey() {
        return this.key;
    }

    public String toString() {
        String keyName;
        StringBuilder sb = new StringBuilder();
        if ((this.modifiers & 0x20000) != 0) {
            sb.append("Shift+");
        }
        if ((this.modifiers & 0x400000) != 0) {
            sb.append("Command+");
        }
        if ((this.modifiers & 0x40000) != 0) {
            sb.append("Ctrl+");
        }
        if ((this.modifiers & 0x10000) != 0) {
            sb.append("Alt+");
        }
        if ((keyName = (String)keyNameLookupTable.get(this.key)) != null) {
            sb.append(keyName);
        } else {
            sb.append(Character.toUpperCase((char)this.key));
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.key;
        result = 31 * result + this.modifiers;
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        KeyStroke other = (KeyStroke)object;
        if (this.key != other.key) {
            return false;
        }
        return this.modifiers == other.modifiers;
    }

    static {
        keyCodeLookupTable.put("BACKSPACE", 8);
        keyCodeLookupTable.put("BREAK", 16777302);
        keyCodeLookupTable.put("DELETE", 127);
        keyCodeLookupTable.put("DOWN", 0x1000002);
        keyCodeLookupTable.put("END", 0x1000008);
        keyCodeLookupTable.put("ENTER", 13);
        keyCodeLookupTable.put("ESC", 27);
        keyCodeLookupTable.put("F1", 0x100000A);
        keyCodeLookupTable.put("F2", 0x100000B);
        keyCodeLookupTable.put("F3", 0x100000C);
        keyCodeLookupTable.put("F4", 0x100000D);
        keyCodeLookupTable.put("F5", 0x100000E);
        keyCodeLookupTable.put("F6", 0x100000F);
        keyCodeLookupTable.put("F7", 0x1000010);
        keyCodeLookupTable.put("F8", 0x1000011);
        keyCodeLookupTable.put("F9", 0x1000012);
        keyCodeLookupTable.put("F10", 0x1000013);
        keyCodeLookupTable.put("F11", 0x1000014);
        keyCodeLookupTable.put("F12", 0x1000015);
        keyCodeLookupTable.put("F13", 0x1000016);
        keyCodeLookupTable.put("F14", 0x1000017);
        keyCodeLookupTable.put("F15", 0x1000018);
        keyCodeLookupTable.put("F16", 0x1000019);
        keyCodeLookupTable.put("F17", 0x100001A);
        keyCodeLookupTable.put("F18", 0x100001B);
        keyCodeLookupTable.put("F19", 0x100001C);
        keyCodeLookupTable.put("F20", 0x100001D);
        keyCodeLookupTable.put("HELP", 0x1000051);
        keyCodeLookupTable.put("HOME", 0x1000007);
        keyCodeLookupTable.put("INSERT", 0x1000009);
        keyCodeLookupTable.put("LEFT", 0x1000003);
        keyCodeLookupTable.put("PAGEDOWN", 0x1000006);
        keyCodeLookupTable.put("PAGEUP", 0x1000005);
        keyCodeLookupTable.put("PAUSE", 0x1000055);
        keyCodeLookupTable.put("PRINTSCREEN", 16777303);
        keyCodeLookupTable.put("RIGHT", 0x1000004);
        keyCodeLookupTable.put("SCROLLLOCK", 16777300);
        keyCodeLookupTable.put("TAB", 9);
        keyCodeLookupTable.put("UP", 0x1000001);
        keyNameLookupTable.put(8, "Backspace");
        keyNameLookupTable.put(9, "Tab");
        keyNameLookupTable.put(13, "Enter");
        keyNameLookupTable.put(27, "Esc");
        keyNameLookupTable.put(127, "Delete");
        keyNameLookupTable.put(16777302, "Break");
        keyNameLookupTable.put(0x1000002, "Down");
        keyNameLookupTable.put(0x1000008, "End");
        keyNameLookupTable.put(0x100000A, "F1");
        keyNameLookupTable.put(0x100000B, "F2");
        keyNameLookupTable.put(0x100000C, "F3");
        keyNameLookupTable.put(0x100000D, "F4");
        keyNameLookupTable.put(0x100000E, "F5");
        keyNameLookupTable.put(0x100000F, "F6");
        keyNameLookupTable.put(0x1000010, "F7");
        keyNameLookupTable.put(0x1000011, "F8");
        keyNameLookupTable.put(0x1000012, "F9");
        keyNameLookupTable.put(0x1000013, "F10");
        keyNameLookupTable.put(0x1000014, "F11");
        keyNameLookupTable.put(0x1000015, "F12");
        keyNameLookupTable.put(0x1000016, "F13");
        keyNameLookupTable.put(0x1000017, "F14");
        keyNameLookupTable.put(0x1000018, "F15");
        keyNameLookupTable.put(0x1000019, "F16");
        keyNameLookupTable.put(0x100001A, "F17");
        keyNameLookupTable.put(0x100001B, "F18");
        keyNameLookupTable.put(0x100001C, "F19");
        keyNameLookupTable.put(0x100001D, "F20");
        keyNameLookupTable.put(0x1000051, "Help");
        keyNameLookupTable.put(0x1000007, "Home");
        keyNameLookupTable.put(0x1000009, "Insert");
        keyNameLookupTable.put(0x1000003, "Left");
        keyNameLookupTable.put(0x1000006, "PageDown");
        keyNameLookupTable.put(0x1000005, "PageUp");
        keyNameLookupTable.put(0x1000055, "Pause");
        keyNameLookupTable.put(16777303, "PrintScreen");
        keyNameLookupTable.put(0x1000004, "Right");
        keyNameLookupTable.put(16777300, "ScrollLock");
        keyNameLookupTable.put(0x1000001, "Up");
    }
}

