/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.agentmanagement.views.helpers;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.netxms.client.AgentTunnel;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.AbstractViewerFilter;

public class TunnelManagerFilter
extends ViewerFilter
implements AbstractViewerFilter {
    private String filterString = null;
    private boolean hideNonProxy = false;
    private boolean hideNonUA = false;

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        AgentTunnel t = (AgentTunnel)element;
        if (this.hideNonUA && !t.isUserAgentInstalled()) {
            return false;
        }
        if (!(!this.hideNonProxy || t.isAgentProxy() || t.isSnmpProxy() || t.isSnmpTrapProxy() || t.isSyslogProxy())) {
            return false;
        }
        if (this.filterString == null || this.filterString.isEmpty()) {
            return true;
        }
        if (t.getAgentVersion().toLowerCase().contains(this.filterString)) {
            return true;
        }
        if (t.isBound() && Integer.toString(t.getActiveChannelCount()).toLowerCase().contains(this.filterString)) {
            return true;
        }
        if (Integer.toString(t.getId()).toLowerCase().contains(this.filterString)) {
            return true;
        }
        if (t.getAddress().getHostAddress().toLowerCase().contains(this.filterString)) {
            return true;
        }
        if (t.isBound() && Registry.getSession().getObjectName(t.getNodeId()).toLowerCase().contains(this.filterString)) {
            return true;
        }
        if (t.getPlatformName().toLowerCase().contains(this.filterString)) {
            return true;
        }
        if (t.isBound() ? "bound".contains(this.filterString) : "unbound".contains(this.filterString)) {
            return true;
        }
        if (t.getSystemInformation().toLowerCase().contains(this.filterString)) {
            return true;
        }
        if (t.getSystemName().toLowerCase().contains(this.filterString)) {
            return true;
        }
        return t.getHardwareIdAsText().toLowerCase().contains(this.filterString);
    }

    public void setFilterString(String filterString) {
        this.filterString = filterString.toLowerCase();
    }

    public void setHideNonProxy(boolean hide) {
        this.hideNonProxy = hide;
    }

    public void setHideNonUA(boolean hide) {
        this.hideNonUA = hide;
    }
}

