/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.alarms.dialogs;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.events.AlarmCategory;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.modules.alarms.widgets.AlarmCategoryList;

public class AlarmCategorySelectionDialog
extends Dialog {
    private static final String TABLE_CONFIG_PREFIX = "AlarmCategorySelectionDialog";
    private AlarmCategoryList alarmCategoryList;
    private PreferenceStore settings;
    private AlarmCategory[] selectedEvents;

    public AlarmCategorySelectionDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Select Alarm Category");
        this.settings = PreferenceStore.getInstance();
        newShell.setSize(this.settings.getAsInteger("AlarmCategorySelectionDialog.cx", 600), this.settings.getAsInteger("AlarmCategorySelectionDialog.cy", 400));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        dialogArea.setLayout((Layout)new FormLayout());
        this.alarmCategoryList = new AlarmCategoryList(dialogArea, 0, TABLE_CONFIG_PREFIX, false);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.alarmCategoryList.setLayoutData((Object)fd);
        this.alarmCategoryList.getViewer().addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        return dialogArea;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button newButton = this.createButton(parent, 3, "&New...", false);
        newButton.setLayoutData((Object)new GridData(16384, 4, true, false));
        newButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Label spacer = new Label(parent, 0);
        spacer.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout layout = (GridLayout)parent.getLayout();
        ++layout.numColumns;
        layout.makeColumnsEqualWidth = false;
        super.createButtonsForButtonBar(parent);
    }

    protected void cancelPressed() {
        this.saveSettings();
        super.cancelPressed();
    }

    protected void okPressed() {
        IStructuredSelection selection = this.alarmCategoryList.getSelection();
        List list = selection.toList();
        this.selectedEvents = list.toArray(new AlarmCategory[list.size()]);
        this.saveSettings();
        super.okPressed();
    }

    private void saveSettings() {
        Point size = this.getShell().getSize();
        this.settings.set("AlarmCategorySelectionDialog.cx", size.x);
        this.settings.set("AlarmCategorySelectionDialog.cy", size.y);
    }

    public AlarmCategory[] getSelectedCategories() {
        return this.selectedEvents;
    }
}

