/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.alarms.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.xnap.commons.i18n.I18n;

public class EditCommentDialog
extends Dialog {
    private I18n i18n = LocalizationHelper.getI18n(EditCommentDialog.class);
    private static final String CONFIG_PREFIX = "EditCommentDialog";
    private LabeledText textControl;
    private String text;
    private long noteID;

    public EditCommentDialog(Shell parentShell, long noteID, String text) {
        super(parentShell);
        this.noteID = noteID;
        this.text = text;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.noteID != 0L ? this.i18n.tr("Edit Comment") : this.i18n.tr("Add comment"));
        PreferenceStore settings = PreferenceStore.getInstance();
        newShell.setSize(settings.getAsInteger("EditCommentDialog.cx", 400), settings.getAsInteger("EditCommentDialog.cy", 350));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        dialogArea.setLayout((Layout)layout);
        this.textControl = new LabeledText(dialogArea, 0, 2818);
        this.textControl.setLabel(this.i18n.tr("Comment"));
        if (this.noteID != 0L) {
            this.textControl.setText(this.text);
        }
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.textControl.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void cancelPressed() {
        this.saveSettings();
        super.cancelPressed();
    }

    protected void okPressed() {
        this.text = this.textControl.getText();
        this.saveSettings();
        super.okPressed();
    }

    private void saveSettings() {
        Point size = this.getShell().getSize();
        PreferenceStore settings = PreferenceStore.getInstance();
        settings.set("EditCommentDialog.cx", size.x);
        settings.set("EditCommentDialog.cy", size.y);
    }

    public String getText() {
        return this.text;
    }
}

